/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalFeed;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Arrays;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFeed"}, service={ExportImportContentProcessor.class, JournalFeedExportImportContentProcessor.class})
public class JournalFeedExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DATA_HANDLER_GROUP_FRIENDLY_URL = "@data_handler_group_friendly_url@";
    private static final Log _log = LogFactoryUtil.getLog(JournalFeedExportImportContentProcessor.class);
    @Reference(target="(model.class.name=java.lang.String)")
    private ExportImportContentProcessor<String> _defaultTextExportImportContentProcessor;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        newGroupFriendlyURL = newGroupFriendlyURL.substring(1);
        String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (String)"/");
        String oldGroupFriendlyURL = friendlyURLParts[2];
        String oldTargetLayoutFriendlyURL = feed.getTargetLayoutFriendlyUrl();
        if (newGroupFriendlyURL.equals(oldGroupFriendlyURL)) {
            String targetLayoutFriendlyURL = null;
            targetLayoutFriendlyURL = friendlyURLParts.length > 3 ? StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/") : StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL), (String)"/@data_handler_group_friendly_url@");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyURL);
        }
        Group targetLayoutGroup = this._groupLocalService.fetchFriendlyURLGroup(portletDataContext.getCompanyId(), "/" + oldGroupFriendlyURL);
        boolean privateLayout = false;
        if (!PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING.equals("/" + friendlyURLParts[1])) {
            privateLayout = true;
        }
        Layout targetLayout = null;
        String targetLayoutFriendlyURL = null;
        if (friendlyURLParts.length > 3) {
            targetLayoutFriendlyURL = StringUtil.merge((Object[])Arrays.copyOfRange(friendlyURLParts, 3, friendlyURLParts.length), (String)"/");
            targetLayoutFriendlyURL = "/" + targetLayoutFriendlyURL;
            targetLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(targetLayoutGroup.getGroupId(), privateLayout, targetLayoutFriendlyURL);
        } else {
            targetLayoutFriendlyURL = oldTargetLayoutFriendlyURL;
            long plid = this._portal.getPlidFromFriendlyURL(portletDataContext.getCompanyId(), targetLayoutFriendlyURL);
            targetLayout = this._layoutLocalService.fetchLayout(plid);
        }
        if (targetLayout == null) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to get target page friendly URL ");
                sb.append(targetLayoutFriendlyURL);
                sb.append(" for feed: ");
                sb.append(feed.getFeedId());
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchLayoutException();
        }
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        portletDataContext.addReferenceElement((ClassedModel)feed, feedElement, (ClassedModel)targetLayout, "dependency", true);
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        newGroupFriendlyURL = newGroupFriendlyURL.substring(1);
        String newTargetLayoutFriendlyURL = StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)newGroupFriendlyURL);
        long plid = this._portal.getPlidFromFriendlyURL(portletDataContext.getCompanyId(), newTargetLayoutFriendlyURL);
        if (plid <= 0L) {
            Group oldGroup = this._groupLocalService.fetchGroup(portletDataContext.getSourceGroupId());
            if (oldGroup == null) {
                return content;
            }
            String oldGroupFriendlyURL = oldGroup.getFriendlyURL();
            oldGroupFriendlyURL = oldGroupFriendlyURL.substring(1);
            newTargetLayoutFriendlyURL = StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)oldGroupFriendlyURL);
        }
        feed.setTargetLayoutFriendlyUrl(newTargetLayoutFriendlyURL);
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this._defaultTextExportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

