/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.layout.admin.util;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SitemapURLProvider.class})
public class JournalArticleSitemapURLProvider
implements SitemapURLProvider {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleSitemapURLProvider.class);
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        if (layout == null || layout.isSystem() && !layout.isTypeAssetDisplay()) {
            return;
        }
        if (layout.isTypeAssetDisplay()) {
            this.visitArticles(element, layoutSet, themeDisplay, this.getDisplayPageTemplateArticles(layout), false);
        } else {
            this.visitArticles(element, layoutSet, themeDisplay, this._getDisplayPageArticles(layoutSet.getGroupId(), layoutUuid), true);
        }
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        int start = -1;
        int end = -1;
        int count = this._journalArticleService.getLayoutArticlesCount(layoutSet.getGroupId());
        if (count > 50000) {
            start = count - 50000;
            end = count;
        }
        List journalArticles = this._journalArticleService.getLayoutArticles(layoutSet.getGroupId(), start, end);
        this.visitArticles(element, layoutSet, themeDisplay, journalArticles, true);
    }

    protected List<JournalArticle> getDisplayPageTemplateArticles(Layout layout) {
        ArrayList<JournalArticle> journalArticles = new ArrayList<JournalArticle>();
        if (layout == null) {
            return journalArticles;
        }
        DynamicQuery assetDisplayPageEntryDynamicQuery = this._assetDisplayPageEntryLocalService.dynamicQuery();
        long classNameId = this._portal.getClassNameId(JournalArticle.class.getName());
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        assetDisplayPageEntryDynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        Property layoutPageTemplateEntryIdProperty = PropertyFactoryUtil.forName((String)"layoutPageTemplateEntryId");
        assetDisplayPageEntryDynamicQuery.add(layoutPageTemplateEntryIdProperty.ne((Object)0L));
        Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
        assetDisplayPageEntryDynamicQuery.add(plidProperty.eq((Object)layout.getPlid()));
        assetDisplayPageEntryDynamicQuery.setProjection((Projection)PropertyFactoryUtil.forName((String)"classPK"));
        List resourcePrimKeys = this._assetDisplayPageEntryLocalService.dynamicQuery(assetDisplayPageEntryDynamicQuery);
        for (Long resourcePrimKey : resourcePrimKeys) {
            try {
                JournalArticle journalArticle = this._journalArticleService.getLatestArticle(resourcePrimKey.longValue());
                if (!journalArticle.isIndexable()) continue;
                journalArticles.add(journalArticle);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return journalArticles;
    }

    protected Layout getDisplayPageTemplateLayout(long groupId, long journalArticleResourcePrimKey) {
        long classNameId = this._portal.getClassNameId(JournalArticle.class.getName());
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(groupId, classNameId, journalArticleResourcePrimKey);
        if (assetDisplayPageEntry == null) {
            return null;
        }
        long assetDisplayPageEntryPlid = assetDisplayPageEntry.getPlid();
        return this._layoutLocalService.fetchLayout(assetDisplayPageEntryPlid);
    }

    protected void visitArticles(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay, List<JournalArticle> journalArticles, boolean headCheck) throws PortalException {
        if (journalArticles.isEmpty()) {
            return;
        }
        HashSet<String> processedArticleIds = new HashSet<String>();
        String portalURL = this._portal.getPortalURL(layoutSet, themeDisplay);
        for (JournalArticle journalArticle : journalArticles) {
            if (processedArticleIds.contains(journalArticle.getArticleId()) || journalArticle.getStatus() != 0 || headCheck && !JournalUtil.isHead(journalArticle)) continue;
            String journalArticleLayoutUuid = journalArticle.getLayoutUuid();
            Layout layout = null;
            layout = Validator.isNotNull((String)journalArticleLayoutUuid) ? this._layoutLocalService.fetchLayoutByUuidAndGroupId(journalArticleLayoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout()) : this.getDisplayPageTemplateLayout(layoutSet.getGroupId(), journalArticle.getResourcePrimKey());
            if (layout == null) continue;
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(this._layoutSetLocalService.getLayoutSet(journalArticle.getGroupId(), false), themeDisplay);
            StringBundler sb = new StringBundler(4);
            if (!groupFriendlyURL.startsWith(portalURL)) {
                sb.append(portalURL);
            }
            sb.append(groupFriendlyURL);
            sb.append("/-/");
            sb.append(journalArticle.getUrlTitle());
            String articleURL = this._portal.getCanonicalURL(sb.toString(), themeDisplay, layout);
            Map alternateURLs = this._sitemap.getAlternateURLs(articleURL, themeDisplay, layout);
            for (String alternateURL : alternateURLs.values()) {
                this._sitemap.addURLElement(element, alternateURL, null, journalArticle.getModifiedDate(), articleURL, alternateURLs);
            }
            processedArticleIds.add(journalArticle.getArticleId());
        }
    }

    private List<JournalArticle> _getDisplayPageArticles(long groupId, String layoutUuid) {
        int start = -1;
        int end = -1;
        int count = this._journalArticleService.getArticlesByLayoutUuidCount(groupId, layoutUuid);
        if (count > 50000) {
            start = count - 50000;
            end = count;
        }
        return this._journalArticleService.getArticlesByLayoutUuid(groupId, layoutUuid, start, end);
    }
}

