/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.model.listener;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalContent;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class JournalArticleModelListener
extends BaseModelListener<JournalArticle> {
    private JournalContent _journalContent;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private Portal _portal;

    public void onAfterRemove(JournalArticle journalArticle) {
        this.clearCache(journalArticle);
        this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsages(this._portal.getClassNameId(JournalArticle.class), journalArticle.getResourcePrimKey());
    }

    public void onAfterUpdate(JournalArticle journalArticle) {
        this.clearCache(journalArticle);
    }

    protected void clearCache(JournalArticle journalArticle) {
        if (journalArticle == null) {
            return;
        }
        this._journalContent.clearCache(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getDDMTemplateKey());
        CacheUtil.clearCache((long)journalArticle.getCompanyId());
    }

    @Reference(unbind="-")
    protected void setJournalContent(JournalContent journalContent) {
        this._journalContent = journalContent;
    }
}

