/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class JournalFolderIndexer
extends BaseIndexer<JournalFolder>
implements FolderIndexer {
    public static final String CLASS_NAME = JournalFolder.class.getName();
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(JournalFolderIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public JournalFolderIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"description", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setSelectAllLocales(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String[] getFolderClassNames() {
        return new String[]{CLASS_NAME};
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._journalFolderModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
    }

    protected void doDelete(JournalFolder folder) throws Exception {
        this.deleteDocument(folder.getCompanyId(), "UID=" + this.uidFactory.getUID((ClassedModel)folder));
    }

    protected Document doGetDocument(JournalFolder folder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing folder " + folder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)folder);
        this.uidFactory.setUID((ClassedModel)folder, document);
        String title = folder.getName();
        if (folder.isInTrash()) {
            title = this._trashHelper.getOriginalTitle(title);
        }
        for (Locale locale : LanguageUtil.getAvailableLocales((long)folder.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), folder.getDescription());
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), title);
        }
        document.addKeyword("folderId", folder.getParentFolderId());
        document.addKeyword("treePath", StringUtil.split((String)folder.getTreePath(), (char)'/'));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + folder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this._createSummary(locale, document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(JournalFolder folder) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), folder.getCompanyId(), this.getDocument(folder), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._journalFolderLocalService.getFolder(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected void reindexFolders(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._journalFolderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(folder -> {
            block3: {
                try {
                    Document document = this.getDocument(folder);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index journal folder " + folder.getFolderId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    private Summary _createSummary(Locale locale, Document document, String titleField, String contentField) {
        String prefix = "snippet_";
        String title = document.get(locale, prefix + titleField, titleField);
        String content = document.get(prefix + contentField, contentField);
        return new Summary(title, content);
    }
}

