/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.JournalFolderModel;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class JournalFolderModelResourcePermissionRegistrar {
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission<JournalFolder>> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    protected void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", JournalFolder.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(JournalFolder.class, JournalFolderModel::getFolderId, arg_0 -> ((JournalFolderLocalService)this._journalFolderLocalService).getFolder(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic<JournalFolder>(this._stagingPermission, "com_liferay_journal_web_portlet_JournalPortlet", JournalFolderModel::getFolderId){

                public Boolean contains(PermissionChecker permissionChecker, String name, JournalFolder journalFolder, String actionId) {
                    if (actionId.equals("SUBSCRIBE")) {
                        return null;
                    }
                    return super.contains(permissionChecker, name, (GroupedModel)journalFolder, actionId);
                }
            });
            consumer.accept(new DynamicInheritancePermissionLogic(modelResourcePermission, this._getFetchParentFunction(), false));
        }, actionId -> {
            if ("ADD_FOLDER".equals(actionId)) {
                return "ADD_SUBFOLDER";
            }
            return actionId;
        }), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<JournalFolder, JournalFolder, PortalException> _getFetchParentFunction() {
        return folder -> {
            long folderId = folder.getParentFolderId();
            if (0L == folderId) {
                return null;
            }
            if (folder.isInTrash()) {
                return this._journalFolderLocalService.fetchJournalFolder(folderId);
            }
            return this._journalFolderLocalService.getFolder(folderId);
        };
    }
}

