/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.journal.util.JournalTransformerListenerRegistry;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={JournalTransformerListenerRegistry.class})
public class DefaultJournalTransformerListenerRegistryImpl
implements JournalTransformerListenerRegistry {
    private final Map<String, TransformerListener> _transformerListeners = new ConcurrentHashMap<String, TransformerListener>();

    public TransformerListener getTransformerListener(String className) {
        return this._transformerListeners.get(className);
    }

    public List<TransformerListener> getTransformerListeners() {
        return ListUtil.filter(new ArrayList<TransformerListener>(this._transformerListeners.values()), transformerListener -> transformerListener.isEnabled());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet)")
    public void registerTransformerListener(TransformerListener transformerListener) {
        Class<?> clazz = transformerListener.getClass();
        this._transformerListeners.put(clazz.getName(), transformerListener);
    }

    public void unregisterTransformerListener(TransformerListener transformerListener) {
        Class<?> clazz = transformerListener.getClass();
        this._transformerListeners.remove(clazz.getName());
    }
}

