/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_8;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeArticleAssets
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeArticleAssets.class);
    private final AssetEntryLocalService _assetEntryLocalService;
    private final CompanyLocalService _companyLocalService;

    public UpgradeArticleAssets(AssetEntryLocalService assetEntryLocalService, CompanyLocalService companyLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.updateDefaultDraftArticleAssets();
    }

    protected void updateDefaultDraftArticleAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List companies = this._companyLocalService.getCompanies();
            for (Company company : companies) {
                this.updateDefaultDraftArticleAssets(company.getCompanyId());
            }
        }
    }

    protected void updateDefaultDraftArticleAssets(long companyId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select resourcePrimKey, indexable from JournalArticle ", "where companyId = ", companyId, " and version = ", 1.0, " and status = ", 2}));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), resourcePrimKey);
                if (assetEntry == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Journal article with resource primary key ", resourcePrimKey, " does not have associated ", "asset entry"}));
                    continue;
                }
                boolean indexable = rs.getBoolean("indexable");
                this._assetEntryLocalService.updateEntry(assetEntry.getClassName(), assetEntry.getClassPK(), null, null, indexable, assetEntry.isVisible());
            }
        }
    }
}

