/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_0_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeJournalContentSearch
extends UpgradeProcess {
    private static final String _NEW_ROOT_PORTLET_ID = "com_liferay_journal_content_web_portlet_JournalContentPortlet";
    private static final String _OLD_ROOT_PORTLET_ID = "56";

    protected void doUpgrade() throws Exception {
        this.upgradePortletId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradePortletId() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select * from JournalContentSearch where portletId like '56%'");
             PreparedStatement ps2 = this.connection.prepareStatement("select contentSearchId from JournalContentSearch where groupId = ? AND privateLayout = ? AND layoutId = ? AND portletId = ? AND articleId = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalContentSearch set portletId = ? where contentSearchId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                ResultSet rs2;
                block60: {
                    long contentSearchId = rs.getLong("contentSearchId");
                    long groupId = rs.getLong("groupId");
                    boolean privateLayout = rs.getBoolean("privateLayout");
                    long layoutId = rs.getLong("layoutId");
                    String portletId = rs.getString("portletId");
                    String articleId = rs.getString("articleId");
                    String newPortletId = StringUtil.replaceFirst((String)portletId, (String)_OLD_ROOT_PORTLET_ID, (String)_NEW_ROOT_PORTLET_ID);
                    ps2.setLong(1, groupId);
                    ps2.setBoolean(2, privateLayout);
                    ps2.setLong(3, layoutId);
                    ps2.setString(4, newPortletId);
                    ps2.setString(5, articleId);
                    rs2 = ps2.executeQuery();
                    Throwable throwable = null;
                    try {
                        if (rs2.next()) {
                            this.runSQL("delete from JournalContentSearch where contentSearchId = " + contentSearchId);
                        } else {
                            ps3.setString(1, newPortletId);
                            ps3.setLong(2, contentSearchId);
                            ps3.addBatch();
                        }
                        if (rs2 == null) continue;
                        if (throwable == null) break block60;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (rs2 == null) throw throwable3;
                            if (throwable == null) {
                                rs2.close();
                                throw throwable3;
                            }
                            try {
                                rs2.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        rs2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                rs2.close();
            }
            ps3.executeBatch();
            return;
        }
    }
}

