/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class UpgradeJournalArticleLocalizedValues
extends UpgradeProcess {
    private static final int _MAX_LENGTH_DESCRIPTION = 4000;
    private static final int _MAX_LENGTH_TITLE = 400;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournalArticleLocalizedValues.class);
    private final CounterLocalService _counterLocalService;
    private final Map<Long, Locale> _defaultSiteLocales = new HashMap<Long, Locale>();

    public UpgradeJournalArticleLocalizedValues(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("JournalArticle", "title") || !this.hasColumn("JournalArticle", "description")) {
            throw new IllegalStateException("JournalArticle must have title and description columns");
        }
        this.upgradeSchema();
        this.updateJournalArticleDefaultLanguageId();
        this.updateJournalArticleLocalizedFields();
        this.dropTitleColumn();
        this.dropDescriptionColumn();
    }

    protected void dropDescriptionColumn() throws Exception {
        block2: {
            try {
                this.runSQL("alter table JournalArticle drop column description");
            }
            catch (SQLException sqlException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)sqlException, (Throwable)sqlException);
            }
        }
    }

    protected void dropTitleColumn() throws Exception {
        block2: {
            try {
                this.runSQL("alter table JournalArticle drop column title");
            }
            catch (SQLException sqlException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)sqlException, (Throwable)sqlException);
            }
        }
    }

    protected void updateJournalArticleDefaultLanguageId() throws Exception {
        if (!this.hasColumn("JournalArticle", "defaultLanguageId")) {
            this.runSQL("alter table JournalArticle add defaultLanguageId VARCHAR(75) null");
        }
        this._updateDefaultLanguage("title", false);
        this._updateDefaultLanguage("content", true);
    }

    protected void updateJournalArticleLocalizedFields() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("insert into JournalArticleLocalization(");
        sb.append("articleLocalizationId, companyId, articlePK, title, ");
        sb.append("description, languageId) values(?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select id_, companyId, title, description, defaultLanguageId from JournalArticle");
             ResultSet rs = ps.executeQuery();){
            ArrayList<UpdateJournalArticleLocalizedFieldsCallable> updateJournalArticleLocalizedFieldsCallables = new ArrayList<UpdateJournalArticleLocalizedFieldsCallable>();
            while (rs.next()) {
                UpdateJournalArticleLocalizedFieldsCallable updateJournalArticleLocalizedFieldsCallable = new UpdateJournalArticleLocalizedFieldsCallable(rs.getLong(1), rs.getLong(2), rs.getString(3), rs.getString(4), rs.getString(5), sb.toString());
                updateJournalArticleLocalizedFieldsCallables.add(updateJournalArticleLocalizedFieldsCallable);
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(updateJournalArticleLocalizedFieldsCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to update journal article localized fields");
            }
        }
    }

    protected void upgradeSchema() throws Exception {
        if (this.hasTable("JournalArticleLocalization")) {
            this.runSQL("drop table JournalArticleLocalization");
        }
        String template = StringUtil.read((InputStream)UpgradeJournalArticleLocalizedValues.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }

    private Map<Locale, String> _getLocalizationMap(String value, String defaultLanguageId) {
        if (Validator.isXml((String)value)) {
            return LocalizationUtil.getLocalizationMap((String)value);
        }
        return HashMapBuilder.put((Object)LocaleUtil.fromLanguageId((String)defaultLanguageId), (Object)value).build();
    }

    private void _log(long articleId, String columnName) {
        if (!_log.isWarnEnabled()) {
            return;
        }
        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Truncated the ", columnName, " value for article ", articleId, " because it is too long"}));
    }

    private String _truncate(String text, int maxBytes) throws Exception {
        byte[] valueBytes = text.getBytes("UTF-8");
        if (valueBytes.length <= maxBytes) {
            return text;
        }
        byte[] convertedValue = new byte[maxBytes];
        System.arraycopy(valueBytes, 0, convertedValue, 0, maxBytes);
        String returnValue = new String(convertedValue, "UTF-8");
        return StringUtil.shorten((String)returnValue, (int)(returnValue.length() - 1));
    }

    private void _updateDefaultLanguage(String columnName, boolean strictUpdate) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select id_, groupId, ", columnName, " from JournalArticle where defaultLanguageId is null or ", "defaultLanguageId = ''"}));
             ResultSet rs = ps.executeQuery();){
            ArrayList<UpdateDefaultLanguageCallable> updateDefaultLanguageCallables = new ArrayList<UpdateDefaultLanguageCallable>();
            while (rs.next()) {
                String columnValue = rs.getString(3);
                if (!Validator.isXml((String)columnValue) && !strictUpdate) continue;
                long groupId = rs.getLong(2);
                Locale defaultSiteLocale = this._defaultSiteLocales.get(groupId);
                if (defaultSiteLocale == null) {
                    defaultSiteLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
                    this._defaultSiteLocales.put(groupId, defaultSiteLocale);
                }
                UpdateDefaultLanguageCallable updateDefaultLanguageCallable = new UpdateDefaultLanguageCallable(rs.getLong(1), columnValue, defaultSiteLocale);
                updateDefaultLanguageCallables.add(updateDefaultLanguageCallable);
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(updateDefaultLanguageCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to update journal article default language IDs");
            }
        }
    }

    private class UpdateJournalArticleLocalizedFieldsCallable
    implements Callable<Boolean> {
        private final long _companyId;
        private final String _defaultLanguageId;
        private final String _description;
        private final long _id;
        private final String _sql;
        private final String _title;

        public UpdateJournalArticleLocalizedFieldsCallable(long id, long companyId, String title, String description, String defaultLanguageId, String sql) throws Exception {
            this._id = id;
            this._companyId = companyId;
            this._title = title;
            this._description = description;
            this._defaultLanguageId = defaultLanguageId;
            this._sql = sql;
        }

        @Override
        public Boolean call() throws Exception {
            Map titleMap = UpgradeJournalArticleLocalizedValues.this._getLocalizationMap(this._title, this._defaultLanguageId);
            Map descriptionMap = UpgradeJournalArticleLocalizedValues.this._getLocalizationMap(this._description, this._defaultLanguageId);
            HashSet locales = new HashSet();
            locales.addAll(titleMap.keySet());
            locales.addAll(descriptionMap.keySet());
            try (PreparedStatement ps = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)UpgradeJournalArticleLocalizedValues.this.connection, (String)this._sql);){
                for (Locale locale : locales) {
                    String localizedTitle = (String)titleMap.get(locale);
                    String localizedDescription = (String)descriptionMap.get(locale);
                    if (localizedTitle != null && localizedTitle.length() > 400) {
                        localizedTitle = StringUtil.shorten((String)localizedTitle, (int)400);
                        UpgradeJournalArticleLocalizedValues.this._log(this._id, "title");
                    }
                    if (localizedDescription != null) {
                        String safeLocalizedDescription = UpgradeJournalArticleLocalizedValues.this._truncate(localizedDescription, 4000);
                        if (localizedDescription != safeLocalizedDescription) {
                            UpgradeJournalArticleLocalizedValues.this._log(this._id, "description");
                        }
                        localizedDescription = safeLocalizedDescription;
                    }
                    ps.setLong(1, UpgradeJournalArticleLocalizedValues.this._counterLocalService.increment());
                    ps.setLong(2, this._companyId);
                    ps.setLong(3, this._id);
                    ps.setString(4, localizedTitle);
                    ps.setString(5, localizedDescription);
                    ps.setString(6, LocaleUtil.toLanguageId((Locale)locale));
                    ps.addBatch();
                }
                try {
                    ps.executeBatch();
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to update localized fields for article " + this._id), (Throwable)exception);
                    Boolean bl = false;
                    if (ps != null) {
                        if (var5_5 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            ps.close();
                        }
                    }
                    return bl;
                }
            }
            return true;
        }
    }

    private class UpdateDefaultLanguageCallable
    implements Callable<Boolean> {
        private final String _defaultLanguageId;
        private final long _id;
        private final String _xml;

        public UpdateDefaultLanguageCallable(long id, String xml, Locale defaultSiteLocale) {
            this._id = id;
            this._xml = xml;
            this._defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)this._xml, (Locale)defaultSiteLocale);
        }

        @Override
        public Boolean call() throws Exception {
            try {
                StringBundler sb = new StringBundler(4);
                sb.append("update JournalArticle set defaultLanguageId = '");
                sb.append(this._defaultLanguageId);
                sb.append("' where id_ = ");
                sb.append(this._id);
                UpgradeJournalArticleLocalizedValues.this.runSQL(UpgradeJournalArticleLocalizedValues.this.connection, sb.toString());
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to update default language ID for article " + this._id), (Throwable)exception);
                return false;
            }
            return true;
        }
    }
}

