/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_8;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeJournalArticle
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select id_, content from JournalArticle where content like ?");){
            ps1.setString(1, "%type=\"radio\"%");
            ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                long id = rs1.getLong("id_");
                String content = rs1.getString("content");
                content = this._convertRadioDynamicElements(content);
                PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
                Throwable throwable = null;
                try {
                    ps2.setString(1, content);
                    ps2.setLong(2, id);
                    ps2.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps2 == null) continue;
                    if (throwable != null) {
                        try {
                            ps2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps2.close();
                }
            }
        }
    }

    private String _convertRadioDynamicElements(String content) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='radio']");
        List nodes = xPath.selectNodes((Object)contentDocument);
        for (Node node : nodes) {
            Element element = (Element)node;
            List dynamicContentElements = element.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String data = String.valueOf(dynamicContentElement.getData());
                data = this._removeUnusedChars(data);
                dynamicContentElement.clearContent();
                dynamicContentElement.addCDATA(data);
            }
        }
        return contentDocument.formattedString();
    }

    private String _removeUnusedChars(String data) {
        if (data != null && data.length() > 3) {
            int start = 0;
            int end = data.length() - 1;
            if (data.charAt(start) == '[' && data.charAt(end) == ']' && data.charAt(start + 1) == '\"' && data.charAt(end - 1) == '\"') {
                data = data.substring(start + 2, end - 1);
            }
        }
        return data;
    }
}

