/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.util;

import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.index.IndexEncoder;
import com.liferay.portal.kernel.cache.index.PortalCacheIndexer;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class, IdentifiableOSGiService.class, JournalContent.class})
public class JournalContentImpl
implements CTEventListener,
IdentifiableOSGiService,
JournalContent {
    protected static final String CACHE_NAME = JournalContent.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(JournalContentImpl.class);
    private static final Method _clearArticleCacheMethod;
    private static final Method _clearTemplateCacheMethod;
    private static PortalCacheIndexer<String, JournalContentKey, JournalArticleDisplay> _journalArticlePortalCacheIndexer;
    private static PortalCacheIndexer<String, JournalContentKey, JournalArticleDisplay> _journalTemplatePortalCacheIndexer;
    private static PortalCache<JournalContentKey, JournalArticleDisplay> _portalCache;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference
    private MultiVMPool _multiVMPool;

    public void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        _portalCache.removeAll();
    }

    public void clearCache(long groupId, String articleId, String ddmTemplateKey) {
        _journalArticlePortalCacheIndexer.removeKeys((Object)JournalContentArticleKeyIndexEncoder.encode(groupId, articleId, ddmTemplateKey));
        if (ClusterInvokeThreadLocal.isEnabled()) {
            try {
                ClusterableInvokerUtil.invokeOnCluster(ClusterInvokeAcceptor.class, (Object)this, (Method)_clearArticleCacheMethod, (Object[])new Object[]{groupId, articleId, ddmTemplateKey});
            }
            catch (Throwable throwable) {
                ReflectionUtil.throwException((Throwable)throwable);
            }
        }
    }

    public void clearCache(String ddmTemplateKey) {
        _journalTemplatePortalCacheIndexer.removeKeys((Object)ddmTemplateKey);
        if (ClusterInvokeThreadLocal.isEnabled()) {
            try {
                ClusterableInvokerUtil.invokeOnCluster(ClusterInvokeAcceptor.class, (Object)this, (Method)_clearTemplateCacheMethod, (Object[])new Object[]{ddmTemplateKey});
            }
            catch (Throwable throwable) {
                ReflectionUtil.throwException((Throwable)throwable);
            }
        }
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, null, this._getDefaultThemeDisplay());
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, portletRequestModel, this._getDefaultThemeDisplay());
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, portletRequestModel, this._getDefaultThemeDisplay());
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        JournalArticleDisplay articleDisplay = this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay != null) {
            return articleDisplay.getContent();
        }
        return null;
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        JournalArticleDisplay articleDisplay;
        String articleId;
        long groupId;
        StopWatch stopWatch;
        block13: {
            stopWatch = new StopWatch();
            stopWatch.start();
            groupId = article.getGroupId();
            articleId = article.getArticleId();
            double version = article.getVersion();
            articleId = StringUtil.toUpperCase((String)GetterUtil.getString((String)articleId));
            ddmTemplateKey = StringUtil.toUpperCase((String)GetterUtil.getString((String)ddmTemplateKey));
            long layoutSetId = 0L;
            boolean lifecycleRender = false;
            boolean secure = false;
            if (portletRequestModel != null) {
                lifecycleRender = "RENDER_PHASE".equals(portletRequestModel.getLifecycle());
            }
            if (themeDisplay != null) {
                try {
                    if (!this._journalArticleModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)article, "VIEW")) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LayoutSet layoutSet = themeDisplay.getLayoutSet();
                layoutSetId = layoutSet.getLayoutSetId();
                if (portletRequestModel == null) {
                    lifecycleRender = themeDisplay.isLifecycleRender();
                }
                secure = themeDisplay.isSecure();
            }
            if (Validator.isNull((String)ddmTemplateKey)) {
                ddmTemplateKey = article.getDDMTemplateKey();
            }
            JournalContentKey journalContentKey = new JournalContentKey(groupId, articleId, version, ddmTemplateKey, layoutSetId, viewMode, languageId, page, secure);
            articleDisplay = null;
            boolean productionMode = CTCollectionThreadLocal.isProductionMode();
            if (productionMode) {
                articleDisplay = (JournalArticleDisplay)_portalCache.get((Serializable)journalContentKey);
            }
            if ((articleDisplay == null || !lifecycleRender) && (articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay)) != null && articleDisplay.isCacheable() && lifecycleRender) {
                try {
                    if (productionMode) {
                        _portalCache.put((Serializable)journalContentKey, (Object)articleDisplay);
                    }
                }
                catch (ClassCastException classCastException) {
                    if (!_log.isWarnEnabled()) break block13;
                    _log.warn((Object)"Unable to cache article display", (Throwable)classCastException);
                }
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"getDisplay for {", groupId, ", ", articleId, ", ", ddmTemplateKey, ", ", viewMode, ", ", languageId, ", ", page, "} takes ", stopWatch.getTime(), " ms"}));
        }
        return articleDisplay;
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            JournalArticle article = this._journalArticleLocalService.getArticle(groupId, articleId, version);
            return this.getDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get display for ", groupId, "", articleId, "", languageId}), (Throwable)portalException);
            }
            return null;
        }
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, int page, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, page, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, 1, portletRequestModel, this._getDefaultThemeDisplay());
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(groupId, articleId, 0);
        return this.getDisplay(article, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, this._getDefaultThemeDisplay());
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, viewMode, languageId, 1, themeDisplay);
    }

    public String getOSGiServiceIdentifier() {
        return JournalContent.class.getName();
    }

    public void onAfterPublish(long ctCollectionId) {
        _portalCache.removeAll();
    }

    @Activate
    protected void activate() {
        _portalCache = this._multiVMPool.getPortalCache(CACHE_NAME);
        _journalArticlePortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new JournalContentArticleKeyIndexEncoder(), _portalCache);
        _journalTemplatePortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new JournalContentTemplateKeyIndexEncoder(), _portalCache);
    }

    @Deactivate
    protected void deactivate() {
        this._multiVMPool.removePortalCache(CACHE_NAME);
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        if (article.getStatus() != 0) {
            return null;
        }
        Date now = new Date();
        Date displayDate = article.getDisplayDate();
        Date expirationDate = article.getExpirationDate();
        if (displayDate != null && displayDate.after(now) || expirationDate != null && expirationDate.before(now)) {
            return null;
        }
        try {
            return this._journalArticleLocalService.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get display for ", article.toString(), " ", languageId}), (Throwable)exception);
            }
            return null;
        }
    }

    protected JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Get article display {", groupId, ", ", articleId, ", ", ddmTemplateKey, "}"}));
            }
            return this._journalArticleLocalService.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get display for ", groupId, " ", articleId, " ", languageId}));
            }
            return null;
        }
    }

    private ThemeDisplay _getDefaultThemeDisplay() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        return serviceContext.getThemeDisplay();
    }

    static {
        try {
            _clearArticleCacheMethod = JournalContent.class.getMethod("clearCache", Long.TYPE, String.class, String.class);
            _clearTemplateCacheMethod = JournalContent.class.getMethod("clearCache", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
    }

    private static class JournalContentTemplateKeyIndexEncoder
    implements IndexEncoder<String, JournalContentKey> {
        private JournalContentTemplateKeyIndexEncoder() {
        }

        public String encode(JournalContentKey journalContentKey) {
            return journalContentKey._ddmTemplateKey;
        }
    }

    private static class JournalContentKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _articleId;
        private final String _ddmTemplateKey;
        private final long _groupId;
        private final String _languageId;
        private final long _layoutSetId;
        private final int _page;
        private final boolean _secure;
        private final double _version;
        private final String _viewMode;

        public boolean equals(Object object) {
            JournalContentKey journalContentKey = (JournalContentKey)object;
            return journalContentKey._groupId == this._groupId && Objects.equals(journalContentKey._articleId, this._articleId) && journalContentKey._version == this._version && Objects.equals(journalContentKey._ddmTemplateKey, this._ddmTemplateKey) && journalContentKey._layoutSetId == this._layoutSetId && Objects.equals(journalContentKey._viewMode, this._viewMode) && Objects.equals(journalContentKey._languageId, this._languageId) && journalContentKey._page == this._page && journalContentKey._secure == this._secure;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._articleId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._version);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._ddmTemplateKey);
            hashCode = HashUtil.hash((int)hashCode, (long)this._layoutSetId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._viewMode);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._languageId);
            hashCode = HashUtil.hash((int)hashCode, (int)this._page);
            return HashUtil.hash((int)hashCode, (boolean)this._secure);
        }

        private JournalContentKey(long groupId, String articleId, double version, String ddmTemplateKey, long layoutSetId, String viewMode, String languageId, int page, boolean secure) {
            this._groupId = groupId;
            this._articleId = articleId;
            this._version = version;
            this._ddmTemplateKey = ddmTemplateKey;
            this._layoutSetId = layoutSetId;
            this._viewMode = viewMode;
            this._languageId = languageId;
            this._page = page;
            this._secure = secure;
        }
    }

    private static class JournalContentArticleKeyIndexEncoder
    implements IndexEncoder<String, JournalContentKey> {
        private JournalContentArticleKeyIndexEncoder() {
        }

        public static String encode(long groupId, String articleId, String ddmTemplateKey) {
            StringBundler sb = new StringBundler(5);
            sb.append(groupId);
            sb.append("_");
            sb.append(articleId);
            sb.append("_");
            sb.append(ddmTemplateKey);
            return sb.toString();
        }

        public String encode(JournalContentKey journalContentKey) {
            return JournalContentArticleKeyIndexEncoder.encode(journalContentKey._groupId, journalContentKey._articleId, journalContentKey._ddmTemplateKey);
        }
    }
}

