/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.asset.auto.tagger.text.extractor;

import com.liferay.asset.auto.tagger.text.extractor.TextExtractor;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TextExtractor.class})
public class JournalArticleTextExtractor
implements TextExtractor<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleTextExtractor.class);
    @Reference
    private DDMIndexer _ddmIndexer;

    public String extract(JournalArticle journalArticle, Locale locale) {
        DDMFormValues ddmFormValues = null;
        try {
            ddmFormValues = journalArticle.getDDMFormValues();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
        if (ddmFormValues == null) {
            return "";
        }
        return this._ddmIndexer.extractIndexableAttributes(journalArticle.getDDMStructure(), ddmFormValues, locale);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }
}

