/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.language.LanguageResources;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseJournalArticleVersionConstraintResolver
implements ConstraintResolver<JournalArticle> {
    @Reference
    protected JournalArticleLocalService journalArticleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseJournalArticleVersionConstraintResolver.class);

    public String getConflictDescriptionKey() {
        return "duplicate-article-version";
    }

    public Class<JournalArticle> getModelClass() {
        return JournalArticle.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-article-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public void resolveConflict(ConstraintResolverContext<JournalArticle> constraintResolverContext) throws PortalException {
        JournalArticle ctArticle = (JournalArticle)constraintResolverContext.getSourceCTModel();
        double latestVersion = 0.0;
        try {
            latestVersion = (Double)constraintResolverContext.getInTarget(() -> {
                JournalArticle latestProductionArticle = this.journalArticleLocalService.getLatestArticle(ctArticle.getResourcePrimKey(), -1, false);
                return latestProductionArticle.getVersion();
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return;
        }
        List articles = ListUtil.filter((List)this.journalArticleLocalService.getArticles(ctArticle.getGroupId(), ctArticle.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator()), article -> article.getCtCollectionId() == ctArticle.getCtCollectionId());
        double currentVersion = MathUtil.format((double)(latestVersion + 0.1 * (double)articles.size()), (int)1, (int)1);
        CTPersistence ctPersistence = this.journalArticleLocalService.getCTPersistence();
        for (JournalArticle article2 : articles) {
            article2.setVersion(currentVersion);
            this.journalArticleLocalService.updateJournalArticle(article2);
            ctPersistence.flush();
            currentVersion = MathUtil.format((double)(currentVersion - 0.1), (int)1, (int)1);
        }
    }
}

