/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.content.compatibility.converter;

import com.liferay.journal.content.compatibility.converter.JournalContentCompatibilityConverter;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JournalContentCompatibilityConverter.class})
public class JournalContentCompatibilityConverterImpl
implements JournalContentCompatibilityConverter {
    private static final String _LATEST_CONTENT_VERSION = "1.0";
    private static final Log _log = LogFactoryUtil.getLog(JournalContentCompatibilityConverterImpl.class);
    @Reference
    private JSONFactory _jsonFactorys;
    @Reference(unbind="-")
    private LayoutLocalService _layoutLocalService;

    public String convert(String content) {
        try {
            Document document = this._convert(SAXReaderUtil.read((String)content));
            return document.formattedString("  ");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return content;
        }
    }

    private Document _convert(Document document) {
        if (this._isLatestVersion(document)) {
            return document;
        }
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("version", _LATEST_CONTENT_VERSION);
        this._convertDDMFields(this._getDefaultLocale(document), rootElement);
        if (!this._hasNestedFields(rootElement)) {
            return document;
        }
        Document oldDocument = document.clone();
        document = SAXReaderUtil.createDocument();
        Element newRootElement = document.addElement("root");
        Element oldRootElement = oldDocument.getRootElement();
        newRootElement.addAttribute("available-locales", oldRootElement.attributeValue("available-locales"));
        newRootElement.addAttribute("default-locale", oldRootElement.attributeValue("default-locale"));
        newRootElement.addAttribute("version", _LATEST_CONTENT_VERSION);
        this._convertNestedFields(newRootElement, oldDocument.getRootElement());
        return document;
    }

    private void _convertDDMFields(Locale defaultLocale, Element element) {
        String type = element.attributeValue("type");
        if (Validator.isNotNull((String)type)) {
            element.addAttribute("type", this._convertDDMFieldType(type));
        }
        this._convertDDMFieldValue(element, type, defaultLocale);
        List dynamicElements = element.elements("dynamic-element");
        for (Element dynamicElement : dynamicElements) {
            this._convertDDMFields(defaultLocale, dynamicElement);
        }
    }

    private String _convertDDMFieldType(String ddmFieldType) {
        if (Objects.equals(ddmFieldType, "boolean")) {
            return "checkbox";
        }
        if (Objects.equals(ddmFieldType, "ddm-color")) {
            return "color";
        }
        if (Objects.equals(ddmFieldType, "ddm-date")) {
            return "date";
        }
        if (Objects.equals(ddmFieldType, "ddm-decimal")) {
            return "numeric";
        }
        if (Objects.equals(ddmFieldType, "ddm-geolocation")) {
            return "geolocation";
        }
        if (Objects.equals(ddmFieldType, "ddm-journal-article")) {
            return "journal_article";
        }
        if (Objects.equals(ddmFieldType, "ddm-image")) {
            return "image";
        }
        if (Objects.equals(ddmFieldType, "ddm-integer")) {
            return "numeric";
        }
        if (Objects.equals(ddmFieldType, "ddm-link-to-page")) {
            return "link_to_layout";
        }
        if (Objects.equals(ddmFieldType, "ddm-number")) {
            return "numeric";
        }
        if (Objects.equals(ddmFieldType, "document_library")) {
            return "document_library";
        }
        if (Objects.equals(ddmFieldType, "text_area")) {
            return "rich_text";
        }
        if (Objects.equals(ddmFieldType, "text_box")) {
            return "text";
        }
        if (Objects.equals(ddmFieldType, "list")) {
            return "select";
        }
        if (Objects.equals(ddmFieldType, "selection_break")) {
            return "separator";
        }
        if (Objects.equals(ddmFieldType, "text")) {
            return "text";
        }
        return ddmFieldType;
    }

    private void _convertDDMFieldValue(Element element, String ddmFieldType, Locale defaultLocale) {
        List dynamicContentElements = element.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            if (Objects.equals(ddmFieldType, "list")) continue;
            String text = dynamicContentElement.getText();
            dynamicContentElement.clearContent();
            dynamicContentElement.addCDATA(this._convertDDMFieldValue(defaultLocale, ddmFieldType, text));
        }
    }

    private String _convertDDMFieldValue(Locale defaultLocale, String ddmFieldType, String value) {
        if (Objects.equals(ddmFieldType, "ddm-link-to-page") || Objects.equals(ddmFieldType, "link_to_layout")) {
            return this._convertLinkToLayoutValue(defaultLocale, value);
        }
        return value;
    }

    private String _convertLinkToLayoutValue(Locale defaultLocale, String value) {
        boolean privateLayout;
        if (JSONUtil.isValid((String)value)) {
            return value;
        }
        Object[] values = StringUtil.split((String)value, (char)'@');
        if (ArrayUtil.isEmpty((Object[])values)) {
            return "";
        }
        JSONObject jsonObject = this._jsonFactorys.createJSONObject();
        long layoutId = GetterUtil.getLong((String)values[0]);
        boolean bl = privateLayout = !Objects.equals(values[1], "public");
        if (values.length > 2) {
            long groupId = GetterUtil.getLong((String)values[2]);
            jsonObject.put("groupId", groupId);
            Layout layout = this._layoutLocalService.fetchLayout(groupId, privateLayout, layoutId);
            if (layout != null) {
                jsonObject.put("id", layout.getUuid()).put("name", layout.getName(defaultLocale)).put("value", layout.getFriendlyURL(defaultLocale));
            }
        }
        jsonObject.put("layoutId", layoutId).put("privateLayout", privateLayout);
        return jsonObject.toString();
    }

    private void _convertNestedFields(Element newElement, Element oldElement) {
        for (Element dynamicElement : oldElement.elements("dynamic-element")) {
            List nestedFieldsElements = dynamicElement.elements("dynamic-element");
            if (nestedFieldsElements.isEmpty()) {
                newElement.add(dynamicElement.createCopy());
                continue;
            }
            Element fieldSetDynamicElement = newElement.addElement("dynamic-element");
            fieldSetDynamicElement.addAttribute("index-type", "");
            fieldSetDynamicElement.addAttribute("instance-id", StringUtil.randomString());
            fieldSetDynamicElement.addAttribute("name", dynamicElement.attributeValue("name") + "FieldSet");
            Element newDynamicElement = fieldSetDynamicElement.addElement("dynamic-element");
            for (Attribute attribute : dynamicElement.attributes()) {
                newDynamicElement.addAttribute(attribute.getName(), attribute.getValue());
            }
            for (Element dynamicContent : dynamicElement.elements("dynamic-content")) {
                newDynamicElement.add(dynamicContent.createCopy());
            }
            this._convertNestedFields(fieldSetDynamicElement, dynamicElement);
        }
    }

    private Locale _getDefaultLocale(Document document) {
        Element rootElement = document.getRootElement();
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        if (defaultLanguageId == null) {
            return LocaleUtil.getSiteDefault();
        }
        return LocaleUtil.fromLanguageId((String)defaultLanguageId);
    }

    private boolean _hasNestedFields(Element element) {
        for (Element dynamicElement : element.elements("dynamic-element")) {
            List nestedFieldsElements = dynamicElement.elements("dynamic-element");
            if (nestedFieldsElements.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean _isLatestVersion(Document document) {
        Element rootElement = document.getRootElement();
        String version = rootElement.attributeValue("version");
        return Validator.isNotNull((String)version) && Objects.equals(version, _LATEST_CONTENT_VERSION);
    }
}

