/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.events;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.util.LinkedAssetEntryIdsUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class JournalServicePreAction
extends Action {
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final Log _log = LogFactoryUtil.getLog(JournalServicePreAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.servicePre(httpServletRequest);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    public void servicePre(HttpServletRequest httpServletRequest) throws PortalException {
        block4: {
            String strutsAction = this._portal.getStrutsAction(httpServletRequest);
            if (!strutsAction.equals(_PATH_PORTAL_LAYOUT)) {
                return;
            }
            long mainJournalArticleId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_j_a_id");
            if (mainJournalArticleId <= 0L) {
                return;
            }
            try {
                JournalArticle mainJournalArticle = this._journalArticleService.getArticle(mainJournalArticleId);
                AssetEntry layoutAssetEntry = this._assetEntryLocalService.getEntry(JournalArticle.class.getName(), mainJournalArticle.getResourcePrimKey());
                httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)layoutAssetEntry);
                LinkedAssetEntryIdsUtil.addLinkedAssetEntryId((HttpServletRequest)httpServletRequest, (long)layoutAssetEntry.getEntryId());
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)noSuchArticleException);
            }
        }
    }
}

