/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;

public class ImageExportDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    private static final Log _log = LogFactoryUtil.getLog(ImageExportDDMFormFieldValueTransformer.class);
    private final DLAppService _dlAppService;
    private final boolean _exportReferencedContent;
    private final PortletDataContext _portletDataContext;
    private final StagedModel _stagedModel;

    public ImageExportDDMFormFieldValueTransformer(DLAppService dlAppService, boolean exportReferencedContent, PortletDataContext portletDataContext, StagedModel stagedModel) {
        this._dlAppService = dlAppService;
        this._exportReferencedContent = exportReferencedContent;
        this._portletDataContext = portletDataContext;
        this._stagedModel = stagedModel;
    }

    public String getFieldType() {
        return "image";
    }

    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            String valueString = value.getString(locale);
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                continue;
            }
            long groupId = GetterUtil.getLong((Object)jsonObject.get("groupId"));
            String uuid = jsonObject.getString("uuid");
            if (groupId == 0L || Validator.isNull((String)uuid)) continue;
            try {
                FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
                if (fileEntry.isInTrash()) continue;
                if (this._exportReferencedContent) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)this._portletDataContext, (StagedModel)this._stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    continue;
                }
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)fileEntry, "dependency", true);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
    }
}

