/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ImageImportDDMFormFieldValueTransformer
implements DDMFormFieldValueTransformer {
    private static final Log _log = LogFactoryUtil.getLog(ImageImportDDMFormFieldValueTransformer.class);
    private final DLAppService _dlAppService;
    private Document _document;
    private final PortletDataContext _portletDataContext;
    private final StagedModel _stagedModel;

    public ImageImportDDMFormFieldValueTransformer(String content, DLAppService dlAppService, PortletDataContext portletDataContext, StagedModel stagedModel) {
        this._dlAppService = dlAppService;
        this._portletDataContext = portletDataContext;
        this._stagedModel = stagedModel;
        this._setContent(content);
    }

    public String getContent() {
        return this._document.asXML();
    }

    public String getFieldType() {
        return "image";
    }

    public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        for (Locale locale : value.getAvailableLocales()) {
            String valueString = value.getString(locale);
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                continue;
            }
            FileEntry importedFileEntry = this._fetchImportedFileEntry(this._portletDataContext, jsonObject.getLong("fileEntryId"), jsonObject.getString("uuid"));
            if (importedFileEntry == null) continue;
            String fileEntryJSON = this._toJSON(jsonObject.getString("alt"), importedFileEntry, jsonObject.getString("height"), jsonObject.getString("type"), jsonObject.getString("url"), jsonObject.getString("width"));
            value.addString(locale, fileEntryJSON);
            XPath xPath = SAXReaderUtil.createXPath((String)StringBundler.concat((String[])new String[]{"//dynamic-element[@type='image']", "/dynamic-content[contains(text(),", HtmlUtil.escapeXPathAttribute((String)valueString), ")]"}));
            List imageNodes = xPath.selectNodes((Object)this._document);
            for (Node imageNode : imageNodes) {
                Element imageElement = (Element)imageNode;
                imageElement.clearContent();
                imageElement.addCDATA(fileEntryJSON);
            }
        }
    }

    private FileEntry _fetchImportedFileEntry(PortletDataContext portletDataContext, long oldClassPK, String uuid) throws PortalException {
        try {
            Map fileEntryPKs = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
            Long classPK = (Long)fileEntryPKs.get(oldClassPK);
            if (classPK == null) {
                if (Validator.isNotNull((String)uuid)) {
                    return this._dlAppService.getFileEntryByUuidAndGroupId(uuid, portletDataContext.getScopeGroupId());
                }
                return null;
            }
            return this._dlAppService.getFileEntry(classPK.longValue());
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to find file entry", (Throwable)portalException);
            }
            return null;
        }
    }

    private void _setContent(String content) {
        block2: {
            try {
                this._document = SAXReaderUtil.read((String)content);
            }
            catch (DocumentException documentException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Invalid content:\n" + content), (Throwable)documentException);
            }
        }
    }

    private String _toJSON(String alt, FileEntry fileEntry, String height, String type, String url, String width) {
        return JSONUtil.put((String)"alt", (Object)alt).put("description", alt).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("height", height).put("name", fileEntry.getFileName()).put("resourcePrimKey", () -> {
            JournalArticle article = (JournalArticle)this._stagedModel;
            return article.getResourcePrimKey();
        }).put("title", fileEntry.getTitle()).put("type", type).put("url", url).put("uuid", fileEntry.getUuid()).put("width", width).toString();
    }
}

