/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.internal.exportimport.content.processor.ImageExportDDMFormFieldValueTransformer;
import com.liferay.journal.internal.exportimport.content.processor.ImageImportDDMFormFieldValueTransformer;
import com.liferay.journal.internal.exportimport.content.processor.JournalArticleExportImportProcessorCache;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ExportImportContentProcessor.class, JournalArticleExportImportContentProcessor.class})
public class JournalArticleExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleExportImportContentProcessor.class);
    private static final Pattern _htmlCommentRegexPattern = Pattern.compile("\\<!--([\\s\\S]*)--\\>");
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)")
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference(target="(model.class.name=java.lang.String)")
    private ExportImportContentProcessor<String> _defaultTextExportImportContentProcessor;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleExportImportProcessorCache _journalArticleExportImportCache;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        JournalArticle article = (JournalArticle)stagedModel;
        DDMStructure ddmStructure = article.getDDMStructure();
        Fields fields = this._getDDMStructureFields(ddmStructure, content);
        if (fields == null) {
            return content;
        }
        boolean journalArticleExportImportCacheEnabled = this._isJournalArticleExportImportProcessorCacheEnabled(stagedModel.getCompanyId());
        String processedContent = null;
        StringBundler sb = null;
        if (journalArticleExportImportCacheEnabled) {
            sb = new StringBundler(3);
            sb.append(stagedModel.getUuid());
            sb.append(exportReferencedContent);
            sb.append(escapeContent);
            processedContent = this._journalArticleExportImportCache.get(sb.toString());
        }
        String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
        if (Validator.isNotNull(processedContent) && portletDataContext.hasPrimaryKey(String.class, path)) {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            if (Validator.isNull((String)entityElement.attributeValue("cached"))) {
                entityElement.addAttribute("cached", "true");
            }
            return processedContent;
        }
        DDMFormValues ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, stagedModel, (Serializable)ddmFormValues, true, true);
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ImageExportDDMFormFieldValueTransformer imageExportDDMFormFieldValueTransformer = new ImageExportDDMFormFieldValueTransformer(this._dlAppService, exportReferencedContent, portletDataContext, stagedModel);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)imageExportDDMFormFieldValueTransformer);
        ddmFormValuesTransformer.transform();
        content = this._replaceExportJournalArticleReferences(portletDataContext, stagedModel, content, ddmStructure, fields, exportReferencedContent);
        content = (String)((Object)this._defaultTextExportImportContentProcessor.replaceExportContentReferences(portletDataContext, stagedModel, (Serializable)((Object)content), exportReferencedContent, escapeContent));
        if (journalArticleExportImportCacheEnabled) {
            this._journalArticleExportImportCache.put(sb.toString(), content);
        }
        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
        entityElement.addAttribute("cached", "false");
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        JournalArticle article = (JournalArticle)stagedModel;
        DDMStructure ddmStructure = this._fetchDDMStructure(portletDataContext, article);
        Fields fields = this._getDDMStructureFields(ddmStructure, content);
        if (fields == null) {
            return content;
        }
        Element entityElement = portletDataContext.getImportDataElement(stagedModel);
        if (GetterUtil.getBoolean((String)entityElement.attributeValue("cached"))) {
            portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)stagedModel));
        }
        content = this._replaceImportJournalArticleReferences(ddmStructure, fields, portletDataContext, stagedModel);
        DDMFormValues ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        List<String> originalContents = this._fetchContentsFromDDMFormValues(ddmFormValues.getDDMFormFieldValues());
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, stagedModel, (Serializable)ddmFormValues);
        List<String> modifiedContents = this._fetchContentsFromDDMFormValues(ddmFormValues.getDDMFormFieldValues());
        for (int i = 0; i < originalContents.size(); ++i) {
            content = StringUtil.replace((String)content, (String)originalContents.get(i), (String)modifiedContents.get(i));
        }
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ImageImportDDMFormFieldValueTransformer imageImportDDMFormFieldValueTransformer = new ImageImportDDMFormFieldValueTransformer(content, this._dlAppService, portletDataContext, stagedModel);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)imageImportDDMFormFieldValueTransformer);
        ddmFormValuesTransformer.transform();
        content = imageImportDDMFormFieldValueTransformer.getContent();
        return (String)((Object)this._defaultTextExportImportContentProcessor.replaceImportContentReferences(portletDataContext, stagedModel, (Serializable)((Object)content)));
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        content = this._excludeHTMLComments(content);
        this._validateJournalArticleReferences(content);
        try {
            this._defaultTextExportImportContentProcessor.validateContentReferences(groupId, (Serializable)((Object)content));
        }
        catch (NoSuchFileEntryException | ExportImportContentValidationException | NoSuchLayoutException exception) {
            if (ExportImportThreadLocal.isImportInProcess()) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(8);
                    sb.append("An invalid ");
                    String type = "page";
                    if (exception instanceof NoSuchFileEntryException || exception.getCause() instanceof NoSuchFileEntryException) {
                        type = "file entry";
                    }
                    sb.append(type);
                    sb.append(" was detected during import when validating ");
                    sb.append("the content below. This is not an error; it ");
                    sb.append("typically means the ");
                    sb.append(type);
                    sb.append(" was deleted.\n");
                    sb.append(content);
                    _log.debug((Object)sb.toString());
                }
                return;
            }
            throw exception;
        }
    }

    private String _excludeHTMLComments(String content) {
        Matcher matcher = _htmlCommentRegexPattern.matcher(content);
        while (matcher.find()) {
            content = matcher.replaceAll("");
            matcher = _htmlCommentRegexPattern.matcher(content);
        }
        return content;
    }

    private List<String> _fetchContentsFromDDMFormValues(List<DDMFormFieldValue> ddmFormFieldValues) {
        return this._fetchContentsFromDDMFormValues(new ArrayList<String>(), ddmFormFieldValues);
    }

    private List<String> _fetchContentsFromDDMFormValues(List<String> contents, List<DDMFormFieldValue> ddmFormFieldValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            contents = this._fetchContentsFromDDMFormValues(contents, ddmFormFieldValue.getNestedDDMFormFieldValues());
            Value value = ddmFormFieldValue.getValue();
            if (value == null) {
                contents.add("");
                continue;
            }
            for (Locale locale : value.getAvailableLocales()) {
                contents.add(value.getString(locale));
            }
        }
        return contents;
    }

    private DDMStructure _fetchDDMStructure(PortletDataContext portletDataContext, JournalArticle article) {
        Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        String ddmStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)article.getDDMStructureKey(), (String)article.getDDMStructureKey());
        return this._ddmStructureLocalService.fetchStructure(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), ddmStructureKey, true);
    }

    private Fields _getDDMStructureFields(DDMStructure ddmStructure, String content) {
        if (ddmStructure == null || Validator.isNull((String)content)) {
            return null;
        }
        try {
            return this._journalConverter.getDDMFields(ddmStructure, content);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    private boolean _isJournalArticleExportImportProcessorCacheEnabled(long companyId) throws Exception {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, companyId);
        return journalServiceConfiguration.journalArticleExportImportProcessorCacheEnabled();
    }

    private String _replaceExportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, DDMStructure ddmStructure, Fields fields, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return content;
        }
        for (Field field : fields) {
            if (!Objects.equals(field.getType(), "journal_article")) continue;
            for (Locale locale : field.getAvailableLocales()) {
                String json = String.valueOf(field.getValue(locale));
                JSONObject jsonObject = null;
                try {
                    jsonObject = this._jsonFactory.createJSONObject(json);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
                if (journalArticle == null) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Staged model with class name ", stagedModel.getModelClassName(), " and primary key ", stagedModel.getPrimaryKeyObj(), " references missing journal article with ", "class primary key ", classPK}));
                    continue;
                }
                JSONObject newArticleJSONObject = JSONUtil.put((String)"articlePrimaryKey", (Object)journalArticle.getPrimaryKey());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Replacing ", json, " with ", newArticleJSONObject.toString()}));
                }
                field.setValue(locale, (Serializable)((Object)newArticleJSONObject.toString()));
                if (exportReferencedContent) {
                    try {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)journalArticle, (String)"dependency");
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) continue;
                        String errorMessage = StringBundler.concat((Object[])new Object[]{"Staged model with class name ", stagedModel.getModelClassName(), " and primary key ", stagedModel.getPrimaryKeyObj(), " references journal article with class ", "primary key ", classPK, " that could not be exported due to ", exception});
                        if (Validator.isNotNull((String)exception.getMessage())) {
                            errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", exception.getMessage()});
                        }
                        _log.debug((Object)errorMessage, (Throwable)exception);
                    }
                    continue;
                }
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)journalArticle, "dependency", true);
            }
        }
        return this._journalConverter.getContent(ddmStructure, fields, ddmStructure.getGroupId());
    }

    private String _replaceImportJournalArticleReferences(DDMStructure ddmStructure, Fields fields, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        for (Field field : fields) {
            if (!Objects.equals(field.getType(), "journal_article")) continue;
            for (Locale locale : field.getAvailableLocales()) {
                JSONObject jsonObject = null;
                Serializable serializable = field.getValue(locale);
                try {
                    jsonObject = this._jsonFactory.createJSONObject(serializable.toString());
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                JournalArticle journalArticle = null;
                long articlePrimaryKey = GetterUtil.getLong((Object)portletDataContext.getNewPrimaryKey(JournalArticle.class + ".primaryKey", (Object)jsonObject.getLong("articlePrimaryKey")));
                if (articlePrimaryKey != 0L) {
                    journalArticle = this._journalArticleLocalService.fetchJournalArticle(articlePrimaryKey);
                }
                if (journalArticle == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get journal article with primary key " + articlePrimaryKey));
                    }
                    portletDataContext.removePrimaryKey(ExportImportPathUtil.getModelPath((StagedModel)stagedModel));
                    continue;
                }
                field.setValue(locale, (Serializable)((Object)JSONUtil.put((String)"className", (Object)JournalArticle.class.getName()).put("classPK", journalArticle.getResourcePrimKey()).put("title", journalArticle.getTitle(journalArticle.getDefaultLanguageId())).put("titleMap", (Object)journalArticle.getTitleMap()).toString()));
            }
        }
        return this._journalConverter.getContent(ddmStructure, fields, ddmStructure.getGroupId());
    }

    private void _validateJournalArticleReferences(String content) throws PortalException {
        NoSuchArticleException throwable;
        block9: {
            throwable = null;
            try {
                Document document = SAXReaderUtil.read((String)content);
                XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='journal_article']");
                List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
                for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
                    Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
                    List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
                    for (Element dynamicContentElement : dynamicContentElements) {
                        String json = dynamicContentElement.getStringValue();
                        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
                        long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                        if (classPK <= 0L) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)"No journal article reference is specified");
                            continue;
                        }
                        JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
                        if (journalArticle != null) continue;
                        if (ExportImportThreadLocal.isImportInProcess()) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)StringBundler.concat((String[])new String[]{"An invalid web content article was ", "detected during import when validating ", "the content below. This is not an error; ", "it typically means the web content ", "article was deleted.\n", content}));
                            }
                            return;
                        }
                        NoSuchArticleException noSuchArticleException = new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No JournalArticle exists with the key ", "{resourcePrimKey=", classPK, "}"}));
                        if (throwable == null) {
                            throwable = noSuchArticleException;
                            continue;
                        }
                        throwable.addSuppressed(noSuchArticleException);
                    }
                }
            }
            catch (DocumentException documentException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)("Invalid content:\n" + content), (Throwable)documentException);
            }
        }
        if (throwable != null) {
            ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(JournalArticleExportImportContentProcessor.class.getName(), throwable);
            exportImportContentValidationException.setType(6);
            throw exportImportContentValidationException;
        }
    }
}

