/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.data.handler;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerChoice;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.exportimport.data.handler.JournalArticleStagedModelDataHandler;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.journal.configuration.JournalServiceConfiguration"}, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "schema.version=4.0.0"}, service={PortletDataHandler.class})
public class JournalPortletDataHandler
extends BasePortletDataHandler {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName(), JournalFolder.class.getName()};
    public static final String NAMESPACE = "journal";
    public static final String SCHEMA_VERSION = "4.0.0";
    private static final Log _log = LogFactoryUtil.getLog(JournalPortletDataHandler.class);
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleStagedModelDataHandler _journalArticleStagedModelDataHandler;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalFeedLocalService _journalFeedLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getResourceName() {
        return "com.liferay.journal";
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.journal";
    }

    public boolean isPublishToLiveByDefault() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return journalServiceConfiguration.publishToLiveByDefaultEnabled();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    public boolean isSupportsDataStrategyMirrorWithOverwriting() {
        return false;
    }

    @Activate
    @Modified
    protected void activate() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(DDMStructure.class, JournalArticle.class), new StagedModelType(DDMTemplate.class, DDMStructure.class), new StagedModelType(JournalArticle.class), new StagedModelType(JournalArticle.class, DDMStructure.class), new StagedModelType(JournalFeed.class), new StagedModelType(JournalFolder.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "web-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerChoice(NAMESPACE, "referenced-content-behavior", 0, new String[]{"include-always", "include-if-modified"})}), new PortletDataHandlerBoolean(NAMESPACE, "version-history", this._isVersionHistoryByDefaultEnabled())}, JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "structures", true, false, null, DDMStructure.class.getName(), JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "templates", true, false, null, DDMTemplate.class.getName(), DDMStructure.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "feeds", true, false, null, JournalFeed.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "folders", true, false, null, JournalFolder.class.getName())});
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(JournalPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._journalArticleLocalService.deleteArticles(portletDataContext.getScopeGroupId());
        this._journalFolderLocalService.deleteFolders(portletDataContext.getGroupId());
        this._ddmTemplateLocalService.deleteTemplates(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class));
        List ddmStructures = this._ddmStructureLocalService.getStructures(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class));
        for (DDMStructure ddmStructure : ddmStructures) {
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId());
            List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(ddmStructure.getStructureId());
            for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
                List ddmStructureLayouts = this._ddmStructureLayoutLocalService.getStructureLayouts(ddmStructure.getGroupId(), ddmStructure.getClassNameId(), ddmStructureVersion.getStructureVersionId());
                for (DDMStructureLayout ddmStructureLayout : ddmStructureLayouts) {
                    this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), ddmStructureLayout.getStructureLayoutId());
                }
            }
            this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(ddmStructure.getStructureId());
        }
        this._ddmStructureLocalService.deleteStructures(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class));
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.journal");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            ExportActionableDynamicQuery feedActionableDynamicQuery = this._journalFeedLocalService.getExportActionableDynamicQuery(portletDataContext);
            feedActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            ExportActionableDynamicQuery folderActionableDynamicQuery = this._journalFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
            folderActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            ActionableDynamicQuery ddmStructureActionableDynamicQuery = this._getDDMStructureActionableDynamicQuery(portletDataContext);
            ddmStructureActionableDynamicQuery.performActions();
            ActionableDynamicQuery ddmStructureDefaultValuesActionableDynamicQuery = this._getDDMStructureDefaultValuesActionableDynamicQuery(portletDataContext);
            ddmStructureDefaultValuesActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this._getDDMTemplateActionableDynamicQuery(portletDataContext);
            ddmTemplateActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            ActionableDynamicQuery articleActionableDynamicQuery = this._getArticleActionableDynamicQuery(portletDataContext);
            articleActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.journal");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "feeds")) {
            Element feedsElement = portletDataContext.getImportDataGroupElement(JournalFeed.class);
            List feedElements = feedsElement.elements();
            for (Element feedElement : feedElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)feedElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "folders")) {
            Element foldersElement = portletDataContext.getImportDataGroupElement(JournalFolder.class);
            List folderElements = foldersElement.elements();
            for (Element folderElement : folderElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        List articleElements = articlesElement.elements();
        if (portletDataContext.getBooleanParameter(NAMESPACE, "structures")) {
            Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
            List ddmStructureElements = ddmStructuresElement.elements();
            for (Element ddmStructureElement : ddmStructureElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
            }
            for (Element ddmStructureElement : ddmStructureElements) {
                List deDataDefinitionFieldLinkElements = portletDataContext.getReferenceDataElements(ddmStructureElement, DEDataDefinitionFieldLink.class, null);
                for (Element deDataDefinitionFieldLinkElement : deDataDefinitionFieldLinkElements) {
                    String path = deDataDefinitionFieldLinkElement.attributeValue("path");
                    DEDataDefinitionFieldLink deDataDefinitionFieldLink = (DEDataDefinitionFieldLink)portletDataContext.getZipEntryAsObject(deDataDefinitionFieldLinkElement, path);
                    StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)deDataDefinitionFieldLink);
                }
            }
            for (Element articleElement : articleElements) {
                String className = articleElement.attributeValue("attached-class-name");
                if (!Validator.isNotNull((String)className) || !className.equals(DDMStructure.class.getName())) continue;
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "templates")) {
            Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
            List ddmTemplateElements = ddmTemplatesElement.elements();
            for (Element ddmTemplateElement : ddmTemplateElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "web-content")) {
            for (Element articleElement : articleElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)articleElement);
            }
            this._journalContent.clearCache();
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(DDMStructure.class.getName(), JournalArticle.class.getName()), new StagedModelType(DDMTemplate.class.getName(), DDMStructure.class.getName()), new StagedModelType(JournalFeed.class.getName()), new StagedModelType(JournalFolder.class.getName())});
            this._populateJournalArticleLastPublishDateCounts(portletDataContext);
            return;
        }
        ActionableDynamicQuery articleActionableDynamicQuery = this._getArticleActionableDynamicQuery(portletDataContext);
        articleActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmStructureActionableDynamicQuery = this._getDDMStructureActionableDynamicQuery(portletDataContext);
        ddmStructureActionableDynamicQuery.performCount();
        ActionableDynamicQuery ddmTemplateActionableDynamicQuery = this._getDDMTemplateActionableDynamicQuery(portletDataContext);
        ddmTemplateActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery feedActionableDynamicQuery = this._journalFeedLocalService.getExportActionableDynamicQuery(portletDataContext);
        feedActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery folderActionableDynamicQuery = this._journalFolderLocalService.getExportActionableDynamicQuery(portletDataContext);
        folderActionableDynamicQuery.performCount();
    }

    private ActionableDynamicQuery _getArticleActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._journalArticleLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            if (portletDataContext.getBooleanParameter(NAMESPACE, "version-history")) {
                return;
            }
            Class<?> clazz = ((Object)((Object)this)).getClass();
            DynamicQuery versionArticleDynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (String)"versionArticle", (ClassLoader)clazz.getClassLoader());
            versionArticleDynamicQuery.setProjection(ProjectionFactoryUtil.alias((Projection)ProjectionFactoryUtil.max((String)"versionArticle.version"), (String)"versionArticle.version"));
            versionArticleDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"this.resourcePrimKey", (String)"versionArticle.resourcePrimKey"));
            Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
            versionArticleDynamicQuery.add(workflowStatusProperty.in(this._journalArticleStagedModelDataHandler.getExportableStatuses()));
            Property versionProperty = PropertyFactoryUtil.forName((String)"version");
            dynamicQuery.add(versionProperty.eq(versionArticleDynamicQuery));
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(JournalArticle.class.getName()));
        return exportActionableDynamicQuery;
    }

    private ActionableDynamicQuery _getDDMStructureActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmStructureLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)this._portal.getClassNameId(JournalArticle.class)));
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DDMStructure.class.getName(), JournalArticle.class.getName()));
        return exportActionableDynamicQuery;
    }

    private ActionableDynamicQuery _getDDMStructureDefaultValuesActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._journalArticleLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(JournalArticle.class.getName(), DDMStructure.class.getName()));
        return exportActionableDynamicQuery;
    }

    private ActionableDynamicQuery _getDDMTemplateActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmTemplateLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
            disjunction.add(classPKProperty.eq((Object)0L));
            DynamicQuery ddmStructureDynamicQuery = this._ddmStructureLocalService.dynamicQuery();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            long ddmStructureClassNameId = this._portal.getClassNameId(DDMStructure.class);
            dynamicQuery.add(classNameIdProperty.eq((Object)ddmStructureClassNameId));
            long articleClassNameId = this._portal.getClassNameId(JournalArticle.class);
            ddmStructureDynamicQuery.add(classNameIdProperty.eq((Object)articleClassNameId));
            ddmStructureDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"structureId"));
            disjunction.add(classPKProperty.in(ddmStructureDynamicQuery));
            dynamicQuery.add((Criterion)disjunction);
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(DDMTemplate.class.getName(), DDMStructure.class.getName()));
        return exportActionableDynamicQuery;
    }

    private boolean _isVersionHistoryByDefaultEnabled() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return journalServiceConfiguration.versionHistoryByDefaultEnabled();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    private void _populateJournalArticleLastPublishDateCounts(PortletDataContext portletDataContext) throws Exception {
        StagedModelType articleStagedModelType;
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        long modelAdditionCount = manifestSummary.getModelAdditionCount(articleStagedModelType = new StagedModelType(JournalArticle.class));
        if (modelAdditionCount > -1L) {
            return;
        }
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(portletDataContext.getScopeGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        if (changesetCollection != null) {
            modelAdditionCount = this._changesetEntryLocalService.getChangesetEntriesCount(changesetCollection.getChangesetCollectionId(), this._portal.getClassNameId(JournalArticleResource.class));
            manifestSummary.addModelAdditionCount(articleStagedModelType, modelAdditionCount);
        }
        long modelDeletionCount = this._exportImportHelper.getModelDeletionCount(portletDataContext, articleStagedModelType);
        manifestSummary.addModelDeletionCount(articleStagedModelType, modelDeletionCount);
    }
}

