/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.layout.admin.util;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.site.util.Sitemap;
import com.liferay.site.util.SitemapURLProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SitemapURLProvider.class})
public class JournalArticleSitemapURLProvider
implements SitemapURLProvider {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleSitemapURLProvider.class);
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        if (layout == null || layout.isSystem() && !layout.isTypeAssetDisplay()) {
            return;
        }
        if (layout.isTypeAssetDisplay()) {
            this.visitArticles(element, layout, layoutSet, themeDisplay, this.getDisplayPageTemplateArticles(layout), false);
        } else {
            this.visitArticles(element, null, layoutSet, themeDisplay, this._getDisplayPageArticles(layoutSet.getGroupId(), layoutUuid), true);
        }
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        int start = -1;
        int end = -1;
        int count = this._journalArticleService.getLayoutArticlesCount(layoutSet.getGroupId());
        if (count > 50000) {
            start = count - 50000;
            end = count;
        }
        List journalArticles = this._journalArticleService.getLayoutArticles(layoutSet.getGroupId(), start, end);
        this.visitArticles(element, null, layoutSet, themeDisplay, journalArticles, true);
    }

    protected List<JournalArticle> getDisplayPageTemplateArticles(Layout layout) {
        ArrayList<JournalArticle> journalArticles = new ArrayList<JournalArticle>();
        if (layout == null) {
            return journalArticles;
        }
        DynamicQuery assetDisplayPageEntryDynamicQuery = this._assetDisplayPageEntryLocalService.dynamicQuery();
        long classNameId = this._portal.getClassNameId(JournalArticle.class.getName());
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        assetDisplayPageEntryDynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        Property layoutPageTemplateEntryIdProperty = PropertyFactoryUtil.forName((String)"layoutPageTemplateEntryId");
        assetDisplayPageEntryDynamicQuery.add(layoutPageTemplateEntryIdProperty.ne((Object)0L));
        Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
        assetDisplayPageEntryDynamicQuery.add(plidProperty.eq((Object)layout.getPlid()));
        assetDisplayPageEntryDynamicQuery.setProjection((Projection)PropertyFactoryUtil.forName((String)"classPK"));
        ArrayList resourcePrimKeys = this._assetDisplayPageEntryLocalService.dynamicQuery(assetDisplayPageEntryDynamicQuery);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null && layoutPageTemplateEntry.isDefaultTemplate()) {
            resourcePrimKeys = new ArrayList(resourcePrimKeys);
            resourcePrimKeys.addAll(this._journalArticleLocalService.getArticlesClassPKsWithDefaultDisplayPage(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getClassTypeId()));
        }
        for (Long resourcePrimKey : resourcePrimKeys) {
            try {
                JournalArticle journalArticle = this._journalArticleService.getLatestArticle(resourcePrimKey.longValue());
                if (!journalArticle.isIndexable()) continue;
                journalArticles.add(journalArticle);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
        return journalArticles;
    }

    protected Layout getDisplayPageTemplateLayout(long groupId, long journalArticleResourcePrimKey, DDMStructure ddmStructure) {
        long classNameId = this._portal.getClassNameId(JournalArticle.class.getName());
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(groupId, classNameId, journalArticleResourcePrimKey);
        if (assetDisplayPageEntry == null) {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchDefaultLayoutPageTemplateEntry(groupId, classNameId, ddmStructure.getStructureId());
            if (layoutPageTemplateEntry == null) {
                return null;
            }
            return this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        }
        if (assetDisplayPageEntry.getType() == 0) {
            return null;
        }
        long assetDisplayPageEntryPlid = assetDisplayPageEntry.getPlid();
        return this._layoutLocalService.fetchLayout(assetDisplayPageEntryPlid);
    }

    protected void visitArticles(Element element, Layout layout, LayoutSet layoutSet, ThemeDisplay themeDisplay, List<JournalArticle> journalArticles, boolean headCheck) throws PortalException {
        if (journalArticles.isEmpty()) {
            return;
        }
        HashSet<String> processedArticleIds = new HashSet<String>();
        String portalURL = this._portal.getPortalURL(layoutSet, themeDisplay);
        for (JournalArticle journalArticle : journalArticles) {
            if (processedArticleIds.contains(journalArticle.getArticleId()) || journalArticle.getStatus() != 0 || headCheck && !JournalUtil.isHead(journalArticle)) continue;
            Layout articleLayout = layout;
            if (articleLayout == null && Validator.isNotNull((String)journalArticle.getLayoutUuid())) {
                articleLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(journalArticle.getLayoutUuid(), layoutSet.getGroupId(), layoutSet.isPrivateLayout());
            } else if (articleLayout == null) {
                articleLayout = this.getDisplayPageTemplateLayout(layoutSet.getGroupId(), journalArticle.getResourcePrimKey(), journalArticle.getDDMStructure());
            }
            if (articleLayout == null) continue;
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(this._layoutSetLocalService.getLayoutSet(journalArticle.getGroupId(), false), themeDisplay, false, false);
            StringBundler sb = new StringBundler(4);
            if (!groupFriendlyURL.startsWith(portalURL)) {
                sb.append(portalURL);
            }
            sb.append(groupFriendlyURL);
            if (Validator.isNotNull((String)journalArticle.getLayoutUuid())) {
                sb.append("/-/");
            } else {
                sb.append("/w/");
            }
            sb.append(journalArticle.getUrlTitle());
            String articleURL = this._portal.getCanonicalURL(sb.toString(), themeDisplay, articleLayout);
            Map alternateURLs = this._portal.getAlternateURLs(articleURL, themeDisplay, articleLayout, this._getAvailableLocales(journalArticle));
            for (String alternateURL : alternateURLs.values()) {
                this._sitemap.addURLElement(element, alternateURL, null, journalArticle.getModifiedDate(), articleURL, alternateURLs);
            }
            processedArticleIds.add(journalArticle.getArticleId());
        }
    }

    private Set<Locale> _getAvailableLocales(JournalArticle journalArticle) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (String availableLanguageId : journalArticle.getAvailableLanguageIds()) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)availableLanguageId));
        }
        return availableLocales;
    }

    private List<JournalArticle> _getDisplayPageArticles(long groupId, String layoutUuid) {
        int start = -1;
        int end = -1;
        int count = this._journalArticleService.getArticlesByLayoutUuidCount(groupId, layoutUuid);
        if (count > 50000) {
            start = count - 50000;
            end = count;
        }
        return this._journalArticleService.getArticlesByLayoutUuid(groupId, layoutUuid, start, end);
    }
}

