/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.model.listener;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.Portal;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DDMStructureModelListener
extends BaseModelListener<DDMStructure> {
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private Portal _portal;

    public void onBeforeRemove(DDMStructure ddmStructure) throws ModelListenerException {
        try {
            this._journalArticleLocalService.deleteArticles(ddmStructure.getGroupId(), DDMStructure.class.getName(), ddmStructure.getStructureId());
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    public void onBeforeUpdate(DDMStructure originalDDMStructure, DDMStructure ddmStructure) throws ModelListenerException {
        if (ddmStructure.getClassNameId() != this._portal.getClassNameId(JournalArticle.class) || Objects.equals(originalDDMStructure.getDefinition(), ddmStructure.getDefinition())) {
            return;
        }
        ActionableDynamicQuery actionableDynamicQuery = this._journalArticleLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property ddmStructureKeyProperty = PropertyFactoryUtil.forName((String)"DDMStructureKey");
            dynamicQuery.add(ddmStructureKeyProperty.eq((Object)originalDDMStructure.getStructureKey()));
        });
        actionableDynamicQuery.setGroupId(originalDDMStructure.getGroupId());
        actionableDynamicQuery.setPerformActionMethod(journalArticle -> this._ddmFieldLocalService.updateDDMFormValues(ddmStructure.getStructureId(), journalArticle.getId(), this._fieldsToDDMFormValuesConverter.convert(ddmStructure, this._journalConverter.getDDMFields(ddmStructure, journalArticle.getContent()))));
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

