/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.batch.BatchIndexingHelper;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import com.liferay.portal.search.spi.model.result.contributor.ModelVisibilityContributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Indexer.class})
public class JournalArticleIndexer
extends BaseIndexer<JournalArticle> {
    public static final String CLASS_NAME = JournalArticle.class.getName();
    @Reference(target="(indexer.class.name=com.liferay.journal.model.JournalArticle)")
    protected ModelSummaryContributor modelSummaryContributor;
    @Reference(target="(indexer.class.name=com.liferay.journal.model.JournalArticle)")
    protected ModelVisibilityContributor modelVisibilityContributor;
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleIndexer.class);
    @Reference
    private BatchIndexingHelper _batchIndexingHelper;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    @Reference(target="(indexer.class.name=com.liferay.journal.model.JournalArticle)")
    private KeywordQueryContributor _keywordQueryContributor;
    private final List<ModelDocumentContributor<JournalArticle>> _modelDocumentContributors = new CopyOnWriteArrayList<ModelDocumentContributor<JournalArticle>>();
    @Reference(target="(indexer.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelPreFilterContributor _modelPreFilterContributor;
    @Reference
    private Portal _portal;

    public JournalArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "articleId", "companyId", "defaultLanguageId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "version", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "description", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setSelectAllLocales(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._journalArticleModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        return this.modelVisibilityContributor.isVisible(classPK, status);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this._modelPreFilterContributor.contribute(contextBooleanFilter, null, searchContext);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, final SearchContext searchContext) throws Exception {
        this._keywordQueryContributor.contribute(searchContext.getKeywords(), searchQuery, new KeywordQueryContributorHelper(){

            public String getClassName() {
                return null;
            }

            public String[] getSearchClassNames() {
                return null;
            }

            public SearchContext getSearchContext() {
                return searchContext;
            }
        });
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=ModelDocumentContributor.class, target="(indexer.class.name=com.liferay.journal.model.JournalArticle)")
    protected void addModelDocumentContributor(ModelDocumentContributor<JournalArticle> modelDocumentContributor) {
        this._modelDocumentContributors.add(modelDocumentContributor);
    }

    protected void doDelete(JournalArticle journalArticle) throws Exception {
        this._deleteDocument(journalArticle);
        this._reindexEveryVersionOfResourcePrimKey(journalArticle.getResourcePrimKey());
    }

    protected Document doGetDocument(JournalArticle journalArticle) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)journalArticle);
        this._modelDocumentContributors.forEach(modelDocumentContributor -> modelDocumentContributor.contribute(document, (BaseModel)journalArticle));
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return this.modelSummaryContributor.getSummary(document, locale, snippet);
    }

    protected void doReindex(JournalArticle article) throws Exception {
        if (this._portal.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            this._deleteDocument(article);
            return;
        }
        this._reindexEveryVersionOfResourcePrimKey(article.getResourcePrimKey());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.fetchJournalArticle(classPK);
        if (journalArticle != null) {
            this._reindexEveryVersionOfResourcePrimKey(journalArticle.getResourcePrimKey());
            return;
        }
        long resourcePrimKey = classPK;
        this._reindexEveryVersionOfResourcePrimKey(resourcePrimKey);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexArticles(companyId);
    }

    protected boolean isIndexAllArticleVersions() {
        JournalServiceConfiguration journalServiceConfiguration = null;
        try {
            journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return journalServiceConfiguration.indexAllArticleVersionsEnabled();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    protected void removeModelDocumentContributor(ModelDocumentContributor<JournalArticle> modelDocumentContributor) {
        this._modelDocumentContributors.remove(modelDocumentContributor);
    }

    private void _deleteDocument(JournalArticle article) throws Exception {
        if (article.getCtCollectionId() == 0L && !CTCollectionThreadLocal.isProductionMode()) {
            return;
        }
        this.deleteDocument(article.getCompanyId(), "UID=" + this.uidFactory.getUID((ClassedModel)article));
    }

    private JournalArticle _fetchLatestIndexableArticleVersion(long resourcePrimKey) {
        JournalArticle latestIndexableArticle = this._journalArticleLocalService.fetchLatestArticle(resourcePrimKey, new int[]{0, 8});
        if (latestIndexableArticle == null) {
            latestIndexableArticle = this._journalArticleLocalService.fetchLatestArticle(resourcePrimKey);
        }
        return latestIndexableArticle;
    }

    private void _reindexArticles(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery;
        if (this.isIndexAllArticleVersions()) {
            indexableActionableDynamicQuery = this._journalArticleLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property property = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(property.ne((Object)this._portal.getClassNameId(DDMStructure.class)));
            });
            indexableActionableDynamicQuery.setInterval(this._batchIndexingHelper.getBulkSize(JournalArticle.class.getName()));
            indexableActionableDynamicQuery.setPerformActionMethod(article -> {
                block2: {
                    try {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(article)});
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index journal article " + article.getId()), (Throwable)portalException);
                    }
                }
            });
        } else {
            indexableActionableDynamicQuery = this._journalArticleResourceLocalService.getIndexableActionableDynamicQuery();
            indexableActionableDynamicQuery.setInterval(this._batchIndexingHelper.getBulkSize(JournalArticleResource.class.getName()));
            indexableActionableDynamicQuery.setPerformActionMethod(articleResource -> {
                block3: {
                    JournalArticle latestIndexableArticle = this._fetchLatestIndexableArticleVersion(articleResource.getResourcePrimKey());
                    if (latestIndexableArticle == null) {
                        return;
                    }
                    try {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(latestIndexableArticle)});
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index journal article " + latestIndexableArticle.getId()), (Throwable)portalException);
                    }
                }
            });
        }
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.performActions();
    }

    private void _reindexEveryVersionOfResourcePrimKey(long resourcePrimKey) throws Exception {
        List journalArticles = this._journalArticleLocalService.getArticlesByResourcePrimKey(resourcePrimKey);
        if (ListUtil.isEmpty((List)journalArticles)) {
            return;
        }
        JournalArticle article = (JournalArticle)journalArticles.get(0);
        if (this._portal.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            this._deleteDocument(article);
            return;
        }
        if (this.isIndexAllArticleVersions()) {
            ArrayList<Document> documents = new ArrayList<Document>(journalArticles.size());
            if (CTCollectionThreadLocal.isProductionMode()) {
                for (JournalArticle journalArticle : journalArticles) {
                    documents.add(this.getDocument(journalArticle));
                }
            } else {
                for (JournalArticle journalArticle : journalArticles) {
                    if (journalArticle.getCtCollectionId() == 0L) continue;
                    documents.add(this.getDocument(journalArticle));
                }
            }
            this._indexWriterHelper.updateDocuments(article.getCompanyId(), documents, this.isCommitImmediately());
        } else {
            JournalArticle latestIndexableArticle = this._fetchLatestIndexableArticleVersion(resourcePrimKey);
            for (JournalArticle journalArticle : journalArticles) {
                if (journalArticle.getId() == latestIndexableArticle.getId()) {
                    this._indexWriterHelper.updateDocument(article.getCompanyId(), this.getDocument(journalArticle));
                    continue;
                }
                this._deleteDocument(journalArticle);
            }
        }
    }
}

