/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.HitsOpenSearchImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenSearch.class})
public class JournalOpenSearchImpl
extends HitsOpenSearchImpl {
    public static final String TITLE = "Liferay Journal Search: ";
    @Reference
    private JournalArticleService _journalArticleService;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public Indexer<JournalArticle> getIndexer() {
        return IndexerRegistryUtil.getIndexer(JournalArticle.class);
    }

    public String getSearchPath() {
        return "";
    }

    public String getTitle(String keywords) {
        return TITLE + keywords;
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        String articleId = result.get("articleId");
        JournalArticle article = this._journalArticleService.getArticle(groupId, articleId);
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(article.getResourcePrimKey());
        String noSuchEntryRedirect = "";
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        if (assetEntry != null) {
            portletURL.setParameter("assetEntryId", String.valueOf(assetEntry.getEntryId()));
            portletURL.setParameter("groupId", String.valueOf(groupId));
            portletURL.setParameter("articleId", articleId);
            noSuchEntryRedirect = portletURL.toString();
        }
        return assetRenderer.getURLViewInContext(themeDisplay, noSuchEntryRedirect);
    }
}

