/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelDocumentContributor.class})
public class JournalArticleModelDocumentContributor
implements ModelDocumentContributor<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelDocumentContributor.class);
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Html _html;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private UIDFactory _uidFactory;

    public void contribute(Document document, JournalArticle journalArticle) {
        boolean visible;
        String[] stringArray;
        String[] descriptionAvailableLanguageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing article " + journalArticle));
        }
        this._uidFactory.setUID((ClassedModel)journalArticle, document);
        String articleId = journalArticle.getArticleId();
        if (journalArticle.isInTrash()) {
            articleId = this._trashHelper.getOriginalTitle(articleId);
        }
        document.addKeywordSortable("articleId", articleId);
        DDMFormValues ddmFormValues = null;
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._portal.getSiteGroupId(journalArticle.getGroupId()), this._portal.getClassNameId(JournalArticle.class), journalArticle.getDDMStructureKey(), true);
        if (ddmStructure != null) {
            document.addKeyword("classTypeId", ddmStructure.getStructureId());
            ddmFormValues = journalArticle.getDDMFormValues();
            if (ddmFormValues != null) {
                for (Locale locale : ddmFormValues.getAvailableLocales()) {
                    String content = this._ddmIndexer.extractIndexableAttributes(ddmStructure, ddmFormValues, locale);
                    document.addText(this._localization.getLocalizedName("content", LocaleUtil.toLanguageId((Locale)locale)), content);
                }
                this._ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
            }
        }
        for (String descriptionAvailableLanguageId : descriptionAvailableLanguageIds = this._localization.getAvailableLanguageIds(journalArticle.getDescriptionMapAsXML())) {
            String description = this._html.stripHtml(journalArticle.getDescription(descriptionAvailableLanguageId));
            document.addText(this._localization.getLocalizedName("description", descriptionAvailableLanguageId), description);
        }
        document.addDate("displayDate", journalArticle.getDisplayDate());
        document.addDate("expirationDate", journalArticle.getExpirationDate());
        document.addKeyword("folderId", journalArticle.getFolderId());
        document.addKeyword("layoutUuid", journalArticle.getLayoutUuid());
        for (String titleAvailableLanguageId : stringArray = this._localization.getAvailableLanguageIds(journalArticle.getTitleMapAsXML())) {
            String title = journalArticle.getTitle(titleAvailableLanguageId);
            document.addText(this._localization.getLocalizedName("title", titleAvailableLanguageId), title);
        }
        document.addKeyword("treePath", StringUtil.split((String)journalArticle.getTreePath(), (char)'/'));
        document.addKeyword("version", journalArticle.getVersion());
        document.addKeyword("ddmStructureKey", journalArticle.getDDMStructureKey());
        document.addKeyword("ddmTemplateKey", journalArticle.getDDMTemplateKey());
        if (ddmFormValues != null) {
            document.addText("defaultLanguageId", LocaleUtil.toLanguageId((Locale)ddmFormValues.getDefaultLocale()));
        } else {
            document.addText("defaultLanguageId", this._language.getLanguageId(LocaleUtil.getSiteDefault()));
        }
        document.addKeyword("head", JournalUtil.isHead(journalArticle));
        boolean headListable = JournalUtil.isHeadListable(journalArticle);
        document.addKeyword("headListable", headListable);
        document.addKeyword("latest", JournalUtil.isLatestArticle(journalArticle));
        if (journalArticle.isScheduled() && headListable && !(visible = GetterUtil.getBoolean((String)document.get("visible")))) {
            document.addKeyword("visible", true);
        }
        for (String titleAvailableLanguageId : stringArray) {
            try {
                document.addKeywordSortable(this._localization.getLocalizedName("urlTitle", titleAvailableLanguageId), journalArticle.getUrlTitle(LocaleUtil.fromLanguageId((String)titleAvailableLanguageId)));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to get friendly URL for article ID ", journalArticle.getId(), " and language ID ", titleAvailableLanguageId}), (Throwable)portalException);
            }
        }
        document.addNumber("versionCount", GetterUtil.getDouble((Object)journalArticle.getVersion()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + journalArticle + " indexed successfully"));
        }
    }
}

