/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search.spi.model.index.contributor;

import com.liferay.journal.model.JournalFolder;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.journal.model.JournalFolder"}, service={ModelDocumentContributor.class})
public class JournalFolderModelDocumentContributor
implements ModelDocumentContributor<JournalFolder> {
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private TrashHelper _trashHelper;

    public void contribute(Document document, JournalFolder journalFolder) {
        document.addKeyword("folderId", journalFolder.getParentFolderId());
        document.addKeyword("treePath", StringUtil.split((String)journalFolder.getTreePath(), (char)'/'));
        String title = journalFolder.getName();
        if (journalFolder.isInTrash()) {
            title = this._trashHelper.getOriginalTitle(title);
        }
        for (Locale locale : this._language.getAvailableLocales(journalFolder.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(this._localization.getLocalizedName("description", languageId), journalFolder.getDescription());
            document.addText(this._localization.getLocalizedName("title", languageId), title);
        }
    }
}

