/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search.spi.model.query.contributor;

import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ExpandoQueryContributor;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.LinkedHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={KeywordQueryContributor.class})
public class JournalArticleKeywordQueryContributor
implements KeywordQueryContributor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleKeywordQueryContributor.class);
    @Reference
    private ExpandoQueryContributor _expandoQueryContributor;
    @Reference
    private QueryHelper _queryHelper;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        String expandoAttributes;
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "articleId", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "classPK", false);
        this._addSearchLocalizedTerm(booleanQuery, searchContext, "content");
        this._addSearchLocalizedTerm(booleanQuery, searchContext, "description");
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "entryClassPK", false);
        this._addSearchLocalizedTerm(booleanQuery, searchContext, "title");
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this._expandoQueryContributor.contribute(expandoAttributes, booleanQuery, new String[]{JournalArticle.class.getName()}, searchContext);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.addHighlightFieldNames(this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"content", "description", "title"}, searchContext));
    }

    private void _addLocalizedFields(BooleanQuery booleanQuery, String fieldName, String value, SearchContext searchContext) {
        String[] localizedFieldNames;
        for (String localizedFieldName : localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{fieldName}, searchContext)) {
            this._addTerm(booleanQuery, localizedFieldName, value);
        }
    }

    private void _addLocalizedQuery(BooleanQuery booleanQuery, BooleanQuery localizedQuery, SearchContext searchContext) {
        block3: {
            BooleanClauseOccur booleanClauseOccur = BooleanClauseOccur.SHOULD;
            if (searchContext.isAndSearch()) {
                booleanClauseOccur = BooleanClauseOccur.MUST;
            }
            try {
                booleanQuery.add((Query)localizedQuery, booleanClauseOccur);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to add localized localized query ", localizedQuery, " with boolean clause occur ", booleanClauseOccur}), (Throwable)parseException);
            }
        }
    }

    private void _addSearchLocalizedTerm(BooleanQuery booleanQuery, SearchContext searchContext, String fieldName) {
        if (Validator.isBlank((String)fieldName)) {
            return;
        }
        String value = GetterUtil.getString((Object)searchContext.getAttribute(fieldName));
        if (Validator.isBlank((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isBlank((String)value)) {
            return;
        }
        if (Validator.isBlank((String)searchContext.getKeywords())) {
            BooleanQueryImpl localizedQuery = new BooleanQueryImpl();
            this._addLocalizedFields((BooleanQuery)localizedQuery, fieldName, value, searchContext);
            this._addLocalizedQuery(booleanQuery, (BooleanQuery)localizedQuery, searchContext);
        } else {
            this._addLocalizedFields(booleanQuery, fieldName, value, searchContext);
        }
    }

    private void _addTerm(BooleanQuery booleanQuery, String field, String value) {
        block2: {
            try {
                booleanQuery.addTerm(field, value, false);
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to add search term to query field:", field, " value:", value, " like:", false}), (Throwable)parseException);
            }
        }
    }
}

