/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search.spi.model.query.contributor;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelPreFilterContributor.class})
public class JournalArticleModelPreFilterContributor
implements ModelPreFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelPreFilterContributor.class);
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private Portal _portal;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    private ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        String ddmTemplateKey;
        String ddmStructureKey;
        block20: {
            long[] classTypeIds;
            this._workflowStatusModelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext);
            Long classNameId = (Long)searchContext.getAttribute("classNameId");
            if (classNameId != null && classNameId != 0L) {
                booleanFilter.addRequiredTerm("classNameId", classNameId.toString());
            }
            if (ArrayUtil.isNotEmpty((long[])(classTypeIds = searchContext.getClassTypeIds()))) {
                TermsFilter classTypeIdsTermsFilter = new TermsFilter("classTypeId");
                classTypeIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
                booleanFilter.add((Filter)classTypeIdsTermsFilter, BooleanClauseOccur.MUST);
            }
            String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
            Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
            if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
                Locale locale;
                block19: {
                    locale = searchContext.getLocale();
                    long[] groupIds = searchContext.getGroupIds();
                    if (ArrayUtil.isNotEmpty((long[])groupIds)) {
                        try {
                            locale = this._portal.getSiteDefaultLocale(groupIds[0]);
                        }
                        catch (PortalException portalException) {
                            if (!_log.isDebugEnabled()) break block19;
                            _log.debug((Throwable)portalException);
                        }
                    }
                }
                try {
                    QueryFilter queryFilter = this._ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, locale);
                    booleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block20;
                    _log.debug((Throwable)exception);
                }
            }
        }
        if (Validator.isNotNull((String)(ddmStructureKey = (String)((Object)searchContext.getAttribute("ddmStructureKey"))))) {
            booleanFilter.addRequiredTerm("ddmStructureKey", ddmStructureKey);
        }
        if (Validator.isNotNull((String)(ddmTemplateKey = (String)((Object)searchContext.getAttribute("ddmTemplateKey"))))) {
            booleanFilter.addRequiredTerm("ddmTemplateKey", ddmTemplateKey);
        }
        boolean head = GetterUtil.getBoolean((Object)searchContext.getAttribute("head"), (boolean)Boolean.TRUE);
        boolean headOrShowNonindexable = GetterUtil.getBoolean((Object)searchContext.getAttribute("headOrShowNonindexable"));
        boolean latest = GetterUtil.getBoolean((Object)searchContext.getAttribute("latest"));
        boolean relatedClassName = GetterUtil.getBoolean((Object)searchContext.getAttribute("relatedClassName"));
        boolean showNonindexable = GetterUtil.getBoolean((Object)searchContext.getAttribute("showNonindexable"));
        if (latest && !relatedClassName && !showNonindexable) {
            booleanFilter.addRequiredTerm("latest", Boolean.TRUE);
        } else if (head && !headOrShowNonindexable && !relatedClassName && !showNonindexable) {
            booleanFilter.addRequiredTerm("head", Boolean.TRUE);
        }
        if (latest && !relatedClassName && showNonindexable) {
            booleanFilter.addRequiredTerm("latest", Boolean.TRUE);
        } else if (!relatedClassName && showNonindexable) {
            booleanFilter.addRequiredTerm("headListable", Boolean.TRUE);
        } else if (headOrShowNonindexable && !relatedClassName) {
            booleanFilter.add((Filter)new BooleanFilter(){
                {
                    this.addTerm("head", Boolean.TRUE);
                    this.addTerm("headListable", Boolean.TRUE);
                }
            }, BooleanClauseOccur.MUST);
        }
        boolean filterExpired = GetterUtil.getBoolean((Object)searchContext.getAttribute("filterExpired"));
        if (!filterExpired) {
            return;
        }
        DateRangeFilterBuilder dateRangeFilterBuilder = this._filterBuilders.dateRangeFilterBuilder();
        dateRangeFilterBuilder.setFieldName("expirationDate");
        String formatPattern = PropsUtil.get((String)"index.date.format.pattern");
        dateRangeFilterBuilder.setFormat(formatPattern);
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)formatPattern);
        dateRangeFilterBuilder.setFrom(dateFormat.format(new Date()));
        dateRangeFilterBuilder.setIncludeLower(false);
        dateRangeFilterBuilder.setIncludeUpper(false);
        booleanFilter.add((Filter)dateRangeFilterBuilder.build());
    }
}

