/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.search.spi.model.result.contributor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelSummaryContributor.class})
public class JournalArticleModelSummaryContributor
implements ModelSummaryContributor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleModelSummaryContributor.class);
    @Reference
    private Html _html;

    public Summary getSummary(Document document, Locale locale, String snippet) {
        String content;
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        Locale snippetLocale = this._getSnippetLocale(document, locale);
        String localizedTitleName = Field.getLocalizedName((Locale)locale, (String)"title");
        String title = document.get(snippetLocale = snippetLocale == null && document.getField(localizedTitleName) == null ? defaultLocale : locale, "snippet_title", "title");
        if (Validator.isBlank((String)title) && !snippetLocale.equals(defaultLocale)) {
            title = document.get(defaultLocale, "snippet_title", "title");
        }
        if (Validator.isBlank((String)(content = this._getDDMContentSummary(document, snippetLocale))) && !snippetLocale.equals(defaultLocale)) {
            content = this._getDDMContentSummary(document, defaultLocale);
        }
        content = this._html.unescape(StringUtil.replace((String)content, (String)"<br />", (String)"\n"));
        Summary summary = new Summary(snippetLocale, title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    private String _getDDMContentSummary(Document document, Locale snippetLocale) {
        String content;
        block3: {
            content = "";
            try {
                content = document.get(snippetLocale, "snippet_description", "description");
                if (!Validator.isBlank((String)content)) {
                    return content;
                }
                content = document.get(snippetLocale, "snippet_content", "content");
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return content;
    }

    private Locale _getSnippetLocale(Document document, Locale locale) {
        String prefix = "snippet_";
        String localizedAssetCategoryTitlesName = prefix + Field.getLocalizedName((Locale)locale, (String)"assetCategoryTitles");
        String localizedContentName = prefix + Field.getLocalizedName((Locale)locale, (String)"content");
        String localizedDescriptionName = prefix + Field.getLocalizedName((Locale)locale, (String)"description");
        String localizedTitleName = prefix + Field.getLocalizedName((Locale)locale, (String)"title");
        if (document.getField(localizedAssetCategoryTitlesName) != null || document.getField(localizedContentName) != null || document.getField(localizedDescriptionName) != null || document.getField(localizedTitleName) != null) {
            return locale;
        }
        return null;
    }
}

