/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.WorkflowedModelPermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ModelResourcePermission.class})
public class JournalArticleModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<JournalArticle> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference
    private WorkflowPermission _workflowPermission;

    protected ModelResourcePermission<JournalArticle> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(JournalArticle.class, JournalArticleModel::getResourcePrimKey, classPK -> {
            JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(classPK.longValue());
            if (article != null) {
                return article;
            }
            return this._journalArticleLocalService.getArticle(classPK.longValue());
        }, (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic<JournalArticle>(this._stagingPermission, "com_liferay_journal_web_portlet_JournalPortlet", JournalArticleModel::getResourcePrimKey){

                public Boolean contains(PermissionChecker permissionChecker, String name, JournalArticle journalArticle, String actionId) {
                    if (actionId.equals("SUBSCRIBE")) {
                        return null;
                    }
                    return super.contains(permissionChecker, name, (GroupedModel)journalArticle, actionId);
                }
            });
            consumer.accept(new WorkflowedModelPermissionLogic(this._workflowPermission, modelResourcePermission, this._groupLocalService, JournalArticleModel::getId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(this._journalFolderModelResourcePermission, this._getFetchParentFunction(), true));
            }
        });
    }

    private UnsafeFunction<JournalArticle, JournalFolder, PortalException> _getFetchParentFunction() {
        return article -> {
            long folderId = article.getFolderId();
            if (0L == folderId) {
                return null;
            }
            if (article.isInTrash()) {
                return this._journalFolderLocalService.fetchFolder(folderId);
            }
            return this._journalFolderLocalService.getFolder(folderId);
        };
    }
}

