/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.journal.configuration.JournalServiceConfiguration"}, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class ContentTransformerListener
extends BaseTransformerListener {
    private static final Log _log = LogFactoryUtil.getLog(ContentTransformerListener.class);
    @Reference
    private Html _html;
    private volatile JournalServiceConfiguration _journalServiceConfiguration;
    @Reference
    private Language _language;

    public boolean isEnabled() {
        return this._journalServiceConfiguration.enableContentTransformerListener();
    }

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this._injectEditInPlace(script, document);
    }

    public Document onXml(Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        this.replace(document, languageId, tokens);
        return document;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._journalServiceConfiguration = (JournalServiceConfiguration)ConfigurableUtil.createConfigurable(JournalServiceConfiguration.class, properties);
    }

    protected void replace(Document document, String languageId, Map<String, String> tokens) {
        block2: {
            try {
                Element rootElement = document.getRootElement();
                long articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
                this.replace(rootElement, articleGroupId, languageId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    protected void replace(Element root, long articleGroupId, String languageId) throws Exception {
        for (Element element : root.elements()) {
            List dynamicContentElements = element.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String text = dynamicContentElement.getText();
                text = this._html.stripComments(text);
                text = this._html.stripHtml(text);
                if (Validator.isNotNull((String)(text = text.trim())) && text.length() >= 7 && text.startsWith("[@") && text.endsWith("@]")) {
                    int pos = (text = text.substring(2, text.length() - 2)).indexOf(";");
                    if (pos == -1) continue;
                    String articleId = text.substring(0, pos);
                    String elementName = text.substring(pos + 1);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(this._getContent(JournalArticleLocalServiceUtil.getArticle((long)articleGroupId, (String)articleId), elementName, languageId));
                    continue;
                }
                if (text == null || !text.startsWith("/image/journal/article?img_id")) continue;
                dynamicContentElement.setText("@cdn_host@@root_path@" + text);
            }
            this.replace(element, articleGroupId, languageId);
        }
    }

    protected String replace(String xml, String languageId, Map<String, String> tokens) {
        block2: {
            try {
                Document document = SAXReaderUtil.read((String)xml);
                this.replace(document, languageId, tokens);
                document.formattedString("  ");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
        return xml;
    }

    private String _getContent(JournalArticle article, String elementName, String languageId) {
        DDMFormValues ddmFormValues = article.getDDMFormValues();
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get(elementName);
        if (ddmFormFieldValues.isEmpty()) {
            return null;
        }
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        Value value = ddmFormFieldValue.getValue();
        return value.getString(this._language.getLocale(languageId));
    }

    private String _injectEditInPlace(String script, Document document) {
        block4: {
            if (!script.contains("$editInPlace(")) {
                return script;
            }
            try {
                List nodes = document.selectNodes("//dynamic-element");
                for (Node node : nodes) {
                    Element element = (Element)node;
                    String name = GetterUtil.getString((String)element.attributeValue("name"));
                    String type = GetterUtil.getString((String)element.attributeValue("type"));
                    if (name.startsWith("reserved-") || !type.equals("text") && !type.equals("text_area") && !type.equals("text_box")) continue;
                    script = this._wrapEditInPlaceField(script, name, type, "data");
                    script = this._wrapEditInPlaceField(script, name, type, "getData()");
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)exception);
            }
        }
        return script;
    }

    private String _wrapEditInPlaceField(String script, String name, String type, String call) {
        String field = StringBundler.concat((String[])new String[]{"$", name, ".", call});
        String wrappedField = StringBundler.concat((String[])new String[]{"<span class=\"journal-content-eip-", type, "\" ", "id=\"journal-content-field-name-", name, "\">", field, "</span>"});
        return StringUtil.replace((String)script, (String)("$editInPlace(" + field + ")"), (String)wrappedField);
    }
}

