/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.asset.display.page.util.AssetDisplayPageUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.info.item.InfoItemReference;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.internal.util.JournalUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalHelper;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JournalTransformer {
    private static final Log _log = LogFactoryUtil.getLog(JournalTransformer.class);
    private static final Log _logOutputAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".OutputAfterListener"));
    private static final Log _logOutputBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".OutputBeforeListener"));
    private static final Log _logScriptAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".ScriptAfterListener"));
    private static final Log _logScriptBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".ScriptBeforeListener"));
    private static final Log _logTokens = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".Tokens"));
    private static final Log _logTransformBefore = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".TransformBefore"));
    private static final Log _logTransfromAfter = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".TransformAfter"));
    private static final Log _logXmlAfterListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".XmlAfterListener"));
    private static final Log _logXmlBeforeListener = LogFactoryUtil.getLog((String)(JournalTransformer.class.getName() + ".XmlBeforeListener"));

    public String transform(JournalArticle article, DDMTemplate ddmTemplate, JournalHelper journalHelper, String languageId, LayoutDisplayPageProviderRegistry layoutDisplayPageProviderRegistry, List<TransformerListener> transformerListeners, PortletRequestModel portletRequestModel, boolean propagateException, String script, ThemeDisplay themeDisplay, String viewMode) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language " + languageId));
        }
        if (Validator.isNull((String)viewMode)) {
            viewMode = "view";
        }
        Map<String, String> tokens = JournalUtil.getTokens(article, ddmTemplate, portletRequestModel, themeDisplay);
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        this._addAllReservedEls(article, languageId, templateNodes, themeDisplay, tokens);
        if (_logTokens.isDebugEnabled()) {
            String tokensString = PropertiesUtil.list(tokens);
            _logTokens.debug((Object)tokensString);
        }
        Document document = article.getDocument();
        document = document.clone();
        if (_logTransformBefore.isDebugEnabled()) {
            _logTransformBefore.debug((Object)document);
        }
        for (TransformerListener transformerListener : transformerListeners) {
            if (_logXmlBeforeListener.isDebugEnabled()) {
                _logXmlBeforeListener.debug((Object)document);
            }
            if (transformerListener != null) {
                document = transformerListener.onXml(document, languageId, tokens);
                if (_logXmlAfterListener.isDebugEnabled()) {
                    _logXmlAfterListener.debug((Object)document);
                }
            }
            if (_logScriptBeforeListener.isDebugEnabled()) {
                _logScriptBeforeListener.debug((Object)script);
            }
            if (transformerListener == null) continue;
            script = transformerListener.onScript(script, document, languageId, tokens);
            if (!_logScriptAfterListener.isDebugEnabled()) continue;
            _logScriptAfterListener.debug((Object)script);
        }
        String templateKey = "DEFAULT_TEMPLATE";
        if (ddmTemplate != null) {
            templateKey = ddmTemplate.getTemplateKey();
        }
        long companyId = article.getCompanyId();
        long companyGroupId = 0L;
        long articleGroupId = article.getGroupId();
        long classNameId = 0L;
        if (tokens != null) {
            companyGroupId = GetterUtil.getLong((String)tokens.get("company_group_id"));
            classNameId = GetterUtil.getLong((String)tokens.get("class_name_id"));
        }
        long scopeGroupId = 0L;
        long siteGroupId = 0L;
        if (themeDisplay != null) {
            companyId = themeDisplay.getCompanyId();
            companyGroupId = themeDisplay.getCompanyGroupId();
            scopeGroupId = themeDisplay.getScopeGroupId();
            siteGroupId = themeDisplay.getSiteGroupId();
        }
        Template template = this._getTemplate(this._getTemplateId(templateKey, companyId, companyGroupId, articleGroupId), script);
        PortletRequest originalPortletRequest = null;
        PortletResponse originalPortletResponse = null;
        HttpServletRequest httpServletRequest = null;
        if (themeDisplay != null && themeDisplay.getRequest() != null) {
            httpServletRequest = themeDisplay.getRequest();
            if (portletRequestModel != null) {
                originalPortletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
                originalPortletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
                httpServletRequest.setAttribute("javax.portlet.request", (Object)portletRequestModel.getPortletRequest());
                httpServletRequest.setAttribute("javax.portlet.response", (Object)portletRequestModel.getPortletResponse());
                httpServletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)portletRequestModel.getLifecycle());
            }
            template.prepare(httpServletRequest);
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            templateNodes.addAll(this._getTemplateNodes(themeDisplay, document.getRootElement(), article.getDDMStructure(), locale));
            templateNodes.addAll(this.includeBackwardsCompatibilityTemplateNodes(templateNodes, -1));
            for (TemplateNode templateNode : templateNodes) {
                template.put((Object)templateNode.getName(), (Object)templateNode);
            }
            if (portletRequestModel != null) {
                template.put((Object)"requestMap", (Object)portletRequestModel.toMap());
            }
            template.put((Object)"articleGroupId", (Object)articleGroupId);
            template.put((Object)"articleLocale", (Object)locale);
            template.put((Object)"company", (Object)this._getCompany(themeDisplay, companyId));
            template.put((Object)"companyId", (Object)companyId);
            template.put((Object)"device", (Object)this._getDevice(themeDisplay));
            Map<String, String> friendlyURLMap = this._getFriendlyURLMap(article, journalHelper, layoutDisplayPageProviderRegistry, themeDisplay);
            template.put((Object)"friendlyURL", (Object)this._getFriendlyURL(friendlyURLMap, languageId));
            template.put((Object)"friendlyURLs", friendlyURLMap);
            template.put((Object)"locale", (Object)this._getLocale(themeDisplay, locale));
            template.put((Object)"permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
            template.put((Object)"randomNamespace", (Object)(StringUtil.randomId() + "_"));
            template.put((Object)"scopeGroupId", (Object)scopeGroupId);
            template.put((Object)"siteGroupId", (Object)siteGroupId);
            String templatesPath = this._getTemplatesPath(companyId, articleGroupId, classNameId);
            template.put((Object)"templatesPath", (Object)templatesPath);
            template.put((Object)"viewMode", (Object)viewMode);
            TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)JournalArticle.class.getName());
            template.putAll(templateHandler.getCustomContextObjects());
            if (themeDisplay != null) {
                template.prepareTaglib(themeDisplay.getRequest(), (HttpServletResponse)new PipingServletResponse(themeDisplay.getResponse(), (Writer)unsyncStringWriter));
            }
            template.put((Object)"groupId", (Object)articleGroupId);
            template.put((Object)"journalTemplatesPath", (Object)templatesPath);
            if (propagateException) {
                template.processTemplate((Writer)unsyncStringWriter);
            } else {
                template.processTemplate((Writer)unsyncStringWriter, this::_getErrorTemplateResource);
            }
        }
        catch (Exception exception) {
            if (exception instanceof DocumentException) {
                throw new TransformException("Unable to read XML document", (Throwable)exception);
            }
            if (exception instanceof IOException) {
                throw new TransformException("Error reading template", (Throwable)exception);
            }
            if (exception instanceof TransformException) {
                throw (TransformException)exception;
            }
            throw new TransformException("Unhandled exception", (Throwable)exception);
        }
        finally {
            if (httpServletRequest != null && portletRequestModel != null) {
                httpServletRequest.setAttribute("javax.portlet.request", (Object)originalPortletRequest);
                httpServletRequest.setAttribute("javax.portlet.response", (Object)originalPortletResponse);
            }
        }
        String output = unsyncStringWriter.toString();
        for (TransformerListener transformerListener : transformerListeners) {
            if (_logOutputBeforeListener.isDebugEnabled()) {
                _logOutputBeforeListener.debug((Object)output);
            }
            output = transformerListener.onOutput(output, languageId, tokens);
            if (!_logOutputAfterListener.isDebugEnabled()) continue;
            _logOutputAfterListener.debug((Object)output);
        }
        if (_logTransfromAfter.isDebugEnabled()) {
            _logTransfromAfter.debug((Object)output);
        }
        return output;
    }

    protected List<TemplateNode> includeBackwardsCompatibilityTemplateNodes(List<TemplateNode> templateNodes, int parentOffset) {
        ArrayList<TemplateNode> backwardsCompatibilityTemplateNodes = new ArrayList<TemplateNode>();
        ++parentOffset;
        for (TemplateNode templateNode : templateNodes) {
            String fieldSetName;
            if (!Objects.equals(templateNode.getType(), "fieldset")) {
                if (parentOffset <= 0) continue;
                backwardsCompatibilityTemplateNodes.add((TemplateNode)templateNode.clone());
                continue;
            }
            List childTemplateNodes = templateNode.getChildren();
            if (ListUtil.isEmpty((List)childTemplateNodes) || !(fieldSetName = templateNode.getName()).endsWith("FieldSet")) continue;
            String name = fieldSetName.substring(0, fieldSetName.indexOf("FieldSet"));
            TemplateNode mainChildTemplateNode = templateNode.getChild(name);
            if (mainChildTemplateNode == null) {
                backwardsCompatibilityTemplateNodes.addAll(this.includeBackwardsCompatibilityTemplateNodes(childTemplateNodes, parentOffset));
                continue;
            }
            if (Objects.equals(mainChildTemplateNode.getType(), "fieldset")) {
                backwardsCompatibilityTemplateNodes.addAll(this.includeBackwardsCompatibilityTemplateNodes(Arrays.asList(mainChildTemplateNode), parentOffset));
                continue;
            }
            ArrayList<TemplateNode> newChildTemplateNodes = new ArrayList<TemplateNode>(childTemplateNodes);
            newChildTemplateNodes.remove(mainChildTemplateNode);
            ArrayList<TemplateNode> newSiblingsTemplateNodes = new ArrayList<TemplateNode>(mainChildTemplateNode.getSiblings());
            if (!newSiblingsTemplateNodes.isEmpty()) {
                newSiblingsTemplateNodes.remove(mainChildTemplateNode);
            }
            mainChildTemplateNode = (TemplateNode)mainChildTemplateNode.clone();
            mainChildTemplateNode.appendChildren(this.includeBackwardsCompatibilityTemplateNodes(newChildTemplateNodes, parentOffset));
            List siblingsTemplateNodes = templateNode.getSiblings();
            if (!siblingsTemplateNodes.isEmpty()) {
                newSiblingsTemplateNodes.addAll(ListUtil.subList((List)siblingsTemplateNodes, (int)1, (int)siblingsTemplateNodes.size()));
            }
            List mainChildSiblingsTemplateNodes = mainChildTemplateNode.getSiblings();
            mainChildSiblingsTemplateNodes.clear();
            mainChildSiblingsTemplateNodes.add(mainChildTemplateNode);
            mainChildSiblingsTemplateNodes.addAll(this.includeBackwardsCompatibilityTemplateNodes(newSiblingsTemplateNodes, parentOffset));
            backwardsCompatibilityTemplateNodes.add(mainChildTemplateNode);
        }
        return backwardsCompatibilityTemplateNodes;
    }

    private void _addAllReservedEls(JournalArticle article, String languageId, List<TemplateNode> templateNodes, ThemeDisplay themeDisplay, Map<String, String> tokens) {
        this._addReservedEl("reserved-article-id", templateNodes, themeDisplay, tokens, article.getArticleId());
        this._addReservedEl("reserved-article-version", templateNodes, themeDisplay, tokens, String.valueOf(article.getVersion()));
        this._addReservedEl("reserved-article-title", templateNodes, themeDisplay, tokens, article.getTitle(languageId));
        this._addReservedEl("reserved-article-url-title", templateNodes, themeDisplay, tokens, article.getUrlTitle());
        this._addReservedEl("reserved-article-description", templateNodes, themeDisplay, tokens, article.getDescription(languageId));
        this._addReservedEl("reserved-article-create-date", templateNodes, themeDisplay, tokens, Time.getRFC822((Date)article.getCreateDate()));
        this._addReservedEl("reserved-article-modified-date", templateNodes, themeDisplay, tokens, Time.getRFC822((Date)article.getModifiedDate()));
        if (article.getDisplayDate() != null) {
            this._addReservedEl("reserved-article-display-date", templateNodes, themeDisplay, tokens, Time.getRFC822((Date)article.getDisplayDate()));
        }
        String smallImageURL = "";
        if (Validator.isNotNull((String)article.getSmallImageURL())) {
            smallImageURL = article.getSmallImageURL();
        } else if (themeDisplay != null && article.isSmallImage()) {
            smallImageURL = StringBundler.concat((Object[])new Object[]{themeDisplay.getPathImage(), "/journal/article?img_id=", article.getSmallImageId(), "&t=", WebServerServletTokenUtil.getToken((long)article.getSmallImageId())});
        }
        this._addReservedEl("reserved-article-small-image-url", templateNodes, themeDisplay, tokens, smallImageURL);
        Object[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        this._addReservedEl("reserved-article-asset-tag-names", templateNodes, themeDisplay, tokens, StringUtil.merge((Object[])assetTagNames));
        this._addReservedEl("reserved-article-author-id", templateNodes, themeDisplay, tokens, String.valueOf(article.getUserId()));
        String userName = "";
        String userEmailAddress = "";
        String userComments = "";
        String userJobTitle = "";
        User user = UserLocalServiceUtil.fetchUserById((long)article.getUserId());
        if (user != null) {
            userName = user.getFullName();
            userEmailAddress = user.getEmailAddress();
            userComments = user.getComments();
            userJobTitle = user.getJobTitle();
        }
        this._addReservedEl("reserved-article-author-name", templateNodes, themeDisplay, tokens, userName);
        this._addReservedEl("reserved-article-author-email-address", templateNodes, themeDisplay, tokens, userEmailAddress);
        this._addReservedEl("reserved-article-author-comments", templateNodes, themeDisplay, tokens, userComments);
        this._addReservedEl("reserved-article-author-job-title", templateNodes, themeDisplay, tokens, userJobTitle);
    }

    private void _addReservedEl(String name, List<TemplateNode> templateNodes, ThemeDisplay themeDisplay, Map<String, String> tokens, String value) {
        templateNodes.add(new TemplateNode(themeDisplay, name, value, "", new HashMap()));
        tokens.put(StringUtil.replace((String)name, (char)'-', (char)'_'), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String _convertToReferenceIfNeeded(String data, DDMFormField ddmFormField) {
        if (Validator.isNull((String)data)) {
            return data;
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        Map optionsReferences = ddmFormFieldOptions.getOptionsReferences();
        String type = ddmFormField.getType();
        if (Objects.equals(type, "checkbox_multiple") || Objects.equals(type, "select") && ddmFormField.isMultiple()) {
            try {
                JSONArray nextJSONArray = JSONFactoryUtil.createJSONArray();
                JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)data);
                for (Object element : jsonArray) {
                    String optionValue = (String)element;
                    nextJSONArray.put(optionsReferences.getOrDefault(optionValue, optionValue));
                }
                return nextJSONArray.toString();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) return data;
                _log.debug((Throwable)exception);
                return data;
            }
        } else if (Objects.equals(type, "grid")) {
            try {
                JSONObject nextJSONObject = JSONFactoryUtil.createJSONObject();
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)data);
                DDMFormFieldOptions rowsDDMFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("rows");
                Map rowOptionsReferences = rowsDDMFormFieldOptions.getOptionsReferences();
                DDMFormFieldOptions columnsDDMFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("columns");
                Map columnsReferences = columnsDDMFormFieldOptions.getOptionsReferences();
                for (String key : jsonObject.keySet()) {
                    String value = jsonObject.getString(key);
                    nextJSONObject.put(rowOptionsReferences.getOrDefault(key, key), columnsReferences.getOrDefault(value, value));
                }
                return nextJSONObject.toString();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) return data;
                _log.debug((Throwable)exception);
                return data;
            }
        } else {
            if (!Objects.equals(type, "radio") && !Objects.equals(type, "select")) return data;
            return optionsReferences.getOrDefault(data, data);
        }
    }

    private TemplateNode _createTemplateNode(DDMFormField ddmFormField, Element dynamicElementElement, Locale locale, ThemeDisplay themeDisplay) throws Exception {
        Iterator iterator;
        String data = "";
        Element dynamicContentElement = dynamicElementElement.element("dynamic-content");
        if (dynamicContentElement != null) {
            data = dynamicContentElement.getText();
        }
        String type = dynamicElementElement.attributeValue("type", ddmFormField.getType());
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (type.equals("image")) {
            JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
            iterator = dataJSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = dataJSONObject.getString(key);
                attributes.put(key, value);
            }
        } else if (type.equals("select") && ddmFormField.isMultiple()) {
            JSONArray dataJSONArray = JSONFactoryUtil.createJSONArray();
            iterator = dynamicContentElement.elementIterator("option");
            while (iterator.hasNext()) {
                Element optionElement = (Element)iterator.next();
                dataJSONArray.put(optionElement.getData());
            }
            data = JSONUtil.toString((JSONArray)dataJSONArray);
        }
        if (dynamicContentElement != null) {
            for (Attribute attribute : dynamicContentElement.attributes()) {
                attributes.put(attribute.getName(), attribute.getValue());
            }
        }
        TemplateNode templateNode = new TemplateNode(themeDisplay, ddmFormField.getFieldReference(), this._convertToReferenceIfNeeded(StringUtil.stripCDATA((String)data), ddmFormField), type, attributes);
        if (dynamicElementElement.element("dynamic-element") == null && dynamicContentElement != null && dynamicContentElement.element("option") != null) {
            List optionElements = dynamicContentElement.elements("option");
            for (Element optionElement : optionElements) {
                templateNode.appendOption(this._convertToReferenceIfNeeded(StringUtil.stripCDATA((String)optionElement.getText()), ddmFormField));
            }
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        Map options = ddmFormFieldOptions.getOptions();
        Map optionsReferences = ddmFormFieldOptions.getOptionsReferences();
        for (Map.Entry entry : options.entrySet()) {
            String optionValue = StringUtil.stripCDATA((String)((String)entry.getKey()));
            String optionReference = optionsReferences.getOrDefault(optionValue, optionValue);
            LocalizedValue localizedLabel = (LocalizedValue)entry.getValue();
            String optionLabel = localizedLabel.getString(locale);
            templateNode.appendOptionMap(optionReference, optionLabel);
        }
        return templateNode;
    }

    private Company _getCompany(ThemeDisplay themeDisplay, long companyId) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany((long)companyId);
    }

    private Device _getDevice(ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    private TemplateResource _getErrorTemplateResource() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return new StringTemplateResource("ftl", journalServiceConfiguration.errorTemplateFTL());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private String _getFriendlyURL(Map<String, String> friendlyURLMap, String languageId) {
        String friendlyURL = friendlyURLMap.get(languageId);
        if (Validator.isNotNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = friendlyURLMap.get(LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNotNull((String)friendlyURL)) {
            return friendlyURL;
        }
        return "";
    }

    private Map<String, String> _getFriendlyURLMap(JournalArticle article, JournalHelper journalHelper, LayoutDisplayPageProviderRegistry layoutDisplayPageProviderRegistry, ThemeDisplay themeDisplay) throws PortalException {
        HashMap<String, String> friendlyURLMap = new HashMap<String, String>();
        LayoutDisplayPageProvider layoutDisplayPageProvider = layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(JournalArticle.class.getName());
        if (layoutDisplayPageProvider == null) {
            return friendlyURLMap;
        }
        LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(JournalArticle.class.getName(), article.getResourcePrimKey()));
        if (themeDisplay == null || layoutDisplayPageObjectProvider == null || themeDisplay.getSiteGroup() == null || !AssetDisplayPageUtil.hasAssetDisplayPage((long)themeDisplay.getScopeGroupId(), (long)layoutDisplayPageObjectProvider.getClassNameId(), (long)layoutDisplayPageObjectProvider.getClassPK(), (long)layoutDisplayPageObjectProvider.getClassTypeId())) {
            return friendlyURLMap;
        }
        Map friendlyURLs = article.getFriendlyURLMap();
        for (Locale locale : friendlyURLs.keySet()) {
            friendlyURLMap.put(LocaleUtil.toLanguageId((Locale)locale), journalHelper.createURLPattern(article, locale, false, "/w/", themeDisplay));
        }
        return friendlyURLMap;
    }

    private Locale _getLocale(ThemeDisplay themeDisplay, Locale locale) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getLocale();
        }
        return locale;
    }

    private Template _getTemplate(String templateId, String script) throws Exception {
        StringTemplateResource templateResource = new StringTemplateResource(templateId, script);
        return TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)true);
    }

    private String _getTemplateId(String templateId, long companyId, long companyGroupId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(groupId);
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    private List<TemplateNode> _getTemplateNodes(ThemeDisplay themeDisplay, Element element, DDMStructure ddmStructure, Locale locale) throws Exception {
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        HashMap<String, TemplateNode> prototypeTemplateNodes = new HashMap<String, TemplateNode>();
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            TemplateNode prototypeTemplateNode;
            String name = dynamicElementElement.attributeValue("name");
            if (Validator.isNull((String)name)) {
                throw new TransformException("Element missing \"name\" attribute");
            }
            DDMFormField ddmFormField = ddmStructure.getDDMFormField(name);
            if (ddmFormField == null) {
                String data = "";
                Element dynamicContentElement = dynamicElementElement.element("dynamic-content");
                if (dynamicContentElement != null) {
                    data = dynamicContentElement.getText();
                }
                templateNodes.add(new TemplateNode(themeDisplay, name, StringUtil.stripCDATA((String)data), "", new HashMap()));
                continue;
            }
            TemplateNode templateNode = this._createTemplateNode(ddmFormField, dynamicElementElement, locale, themeDisplay);
            if (dynamicElementElement.element("dynamic-element") != null) {
                templateNode.appendChildren(this._getTemplateNodes(themeDisplay, dynamicElementElement, ddmStructure, locale));
            }
            if ((prototypeTemplateNode = (TemplateNode)prototypeTemplateNodes.get(name)) == null) {
                prototypeTemplateNode = templateNode;
                prototypeTemplateNodes.put(name, prototypeTemplateNode);
                templateNodes.add(templateNode);
            }
            prototypeTemplateNode.appendSibling(templateNode);
        }
        return templateNodes;
    }

    private String _getTemplatesPath(long companyId, long groupId, long classNameId) {
        return StringBundler.concat((Object[])new Object[]{"_TEMPLATE_CONTEXT_", "/", companyId, "/", groupId, "/", classNameId});
    }
}

