/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class RegexTransformerListener
extends BaseTransformerListener {
    private static final Log _log = LogFactoryUtil.getLog(RegexTransformerListener.class);
    private List<Pattern> _patterns;
    private List<String> _replacements;

    public String onOutput(String output, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return this.replace(output);
    }

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this.replace(script);
    }

    @Activate
    protected void activate() {
        this._patterns = new ArrayList<Pattern>();
        this._replacements = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String regex = PropsUtil.get((String)("journal.transformer.regex.pattern." + i));
            String replacement = PropsUtil.get((String)("journal.transformer.regex.replacement." + i));
            if (Validator.isNull((String)regex) || Validator.isNull((String)replacement)) break;
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Pattern ", regex, " will be replaced with ", replacement}));
            }
            this._patterns.add(Pattern.compile(regex));
            this._replacements.add(replacement);
        }
    }

    protected String replace(String s) {
        if (s == null) {
            return s;
        }
        for (int i = 0; i < this._patterns.size(); ++i) {
            Pattern pattern = this._patterns.get(i);
            String replacement = this._replacements.get(i);
            Matcher matcher = pattern.matcher(s);
            s = matcher.replaceAll(replacement);
        }
        return s;
    }
}

