/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import java.util.ArrayList;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={TransformerListener.class})
public class TokensTransformerListener
extends BaseTransformerListener {
    private static final Log _log = LogFactoryUtil.getLog(TokensTransformerListener.class);

    public String onOutput(String output, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return this.replace(output, tokens);
    }

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this.replace(script, tokens);
    }

    protected String replace(String s, Map<String, String> tokens) {
        if (tokens.isEmpty()) {
            return s;
        }
        ArrayList<String> escapedKeysList = null;
        ArrayList<String> escapedValuesList = null;
        ArrayList<String> keysList = null;
        ArrayList<String> valuesList = null;
        ArrayList<String> tempEscapedKeysList = null;
        ArrayList<String> tempEscapedValuesList = null;
        boolean hasKey = false;
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            String key = entry.getKey();
            if (Validator.isNull((String)key) || !s.contains(key)) continue;
            if (!hasKey) {
                escapedKeysList = new ArrayList<String>();
                escapedValuesList = new ArrayList<String>();
                keysList = new ArrayList<String>();
                valuesList = new ArrayList<String>();
                tempEscapedKeysList = new ArrayList<String>();
                tempEscapedValuesList = new ArrayList<String>();
                hasKey = true;
            }
            String actualKey = StringBundler.concat((String[])new String[]{"@", key, "@"});
            String escapedKey = StringBundler.concat((String[])new String[]{"@", actualKey, "@"});
            String tempEscapedKey = StringBundler.concat((String[])new String[]{"[$TEMP_ESCAPED_AT_OPEN$]", key, "[$_TEMP_ESCAPED_AT_CLOSE$]"});
            escapedKeysList.add(escapedKey);
            escapedValuesList.add(tempEscapedKey);
            keysList.add(actualKey);
            valuesList.add(GetterUtil.getString((String)entry.getValue()));
            tempEscapedKeysList.add(tempEscapedKey);
            tempEscapedValuesList.add(actualKey);
        }
        if (!hasKey) {
            return s;
        }
        s = StringUtil.replace((String)s, (String[])escapedKeysList.toArray(new String[0]), (String[])escapedValuesList.toArray(new String[0]));
        s = StringUtil.replace((String)s, (String[])keysList.toArray(new String[0]), (String[])valuesList.toArray(new String[0]));
        s = StringUtil.replace((String)s, (String[])tempEscapedKeysList.toArray(new String[0]), (String[])tempEscapedValuesList.toArray(new String[0]));
        return s;
    }
}

