/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.trash;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.BaseTrashHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseJournalTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return JournalFolderLocalServiceUtil.getFolder((long)containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return JournalFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        List folders = JournalFolderLocalServiceUtil.getFolders((long)this.getGroupId(classPK), (long)parentContainerModelId, (int)start, (int)end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (JournalFolder curFolder : folders) {
            containerModels.add((ContainerModel)curFolder);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        return JournalFolderLocalServiceUtil.getFoldersCount((long)this.getGroupId(classPK), (long)parentContainerModelId);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "folder";
    }

    public String getSubcontainerModelName() {
        return "folder";
    }

    public String getTrashContainedModelName() {
        return "article";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalArticleLocalServiceUtil.searchCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderLocalServiceUtil.getFoldersCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderLocalServiceUtil.getFoldersAndArticlesCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        List foldersAndArticles = JournalFolderLocalServiceUtil.getFoldersAndArticles((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end, orderByComparator);
        for (Object folderOrArticle : foldersAndArticles) {
            if (folderOrArticle instanceof JournalFolder) {
                JournalFolder curFolder = (JournalFolder)folderOrArticle;
                trashedModels.add((TrashedModel)curFolder);
                continue;
            }
            JournalArticle article = (JournalArticle)folderOrArticle;
            trashedModels.add((TrashedModel)article);
        }
        return trashedModels;
    }

    protected abstract long getGroupId(long var1) throws PortalException;
}

