/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.helper;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JournalArticleImageUpgradeHelper.class})
public class JournalArticleImageUpgradeHelper {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleImageUpgradeHelper.class);
    private static final Pattern _oldDocumentLibraryURLPattern = Pattern.compile("uuid=([^&]+)&groupId=([^&]+)");
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Html _html;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getDocumentLibraryValue(String url) {
        try {
            FileEntry fileEntry = this.getFileEntryFromURL(url);
            if (fileEntry == null) {
                return "";
            }
            return JSONUtil.put((String)"groupId", (Object)fileEntry.getGroupId()).put("title", fileEntry.getTitle()).put("type", "document").put("uuid", fileEntry.getUuid()).toString();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    public FileEntry getFileEntryFromURL(String url) {
        FileEntry fileEntry;
        block6: {
            fileEntry = null;
            try {
                if (url.contains("/c/document_library/get_file?") || url.contains("/image/image_gallery?")) {
                    fileEntry = this._getFileEntryByOldDocumentLibraryURL(url);
                } else if (url.contains("/documents/")) {
                    fileEntry = this._getFileEntryByDocumentLibraryURL(url);
                }
            }
            catch (PortalException portalException) {
                String message = "Unable to get file entry from URL " + url;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)portalException);
                }
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)message);
            }
        }
        return fileEntry;
    }

    public long getFolderId(long userId, long groupId, long resourcePrimKey) throws PortalException {
        long repositoryId = this._getRepositoryId(groupId);
        try {
            Folder folder = this._portletFileRepository.getPortletFolder(repositoryId, 0L, String.valueOf(resourcePrimKey));
            return folder.getFolderId();
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get folder for " + String.valueOf(resourcePrimKey)), (Throwable)noSuchFolderException);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            Folder folder = this._portletFileRepository.addPortletFolder(userId, repositoryId, 0L, String.valueOf(resourcePrimKey), serviceContext);
            return folder.getFolderId();
        }
    }

    private FileEntry _getFileEntryByDocumentLibraryURL(String url) throws PortalException {
        int x = url.indexOf("/documents/");
        int y = url.indexOf("?");
        if (y == -1) {
            y = url.length();
        }
        url = url.substring(x, y);
        String[] parts = StringUtil.split((String)url, (char)'/');
        long groupId = GetterUtil.getLong((String)parts[2]);
        String uuid = null;
        uuid = parts.length == 5 ? this._getUuidByDocumentLibraryURLWithoutUuid(parts) : parts[5];
        return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
    }

    private FileEntry _getFileEntryByOldDocumentLibraryURL(String url) throws PortalException {
        Matcher matcher = _oldDocumentLibraryURLPattern.matcher(url);
        if (!matcher.find()) {
            return null;
        }
        long groupId = GetterUtil.getLong((String)matcher.group(2));
        return this._dlAppLocalService.getFileEntryByUuidAndGroupId(matcher.group(1), groupId);
    }

    private long _getRepositoryId(long groupId) throws PortalException {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, "com.liferay.journal");
        if (repository != null) {
            return repository.getRepositoryId();
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        repository = this._portletFileRepository.addPortletRepository(groupId, "com.liferay.journal", serviceContext);
        return repository.getRepositoryId();
    }

    private String _getUuidByDocumentLibraryURLWithoutUuid(String[] splitURL) throws PortalException {
        long groupId = GetterUtil.getLong((String)splitURL[2]);
        long folderId = GetterUtil.getLong((String)splitURL[3]);
        String title = HttpComponentsUtil.decodeURL((String)this._html.escape(splitURL[4]));
        try {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(groupId, folderId, title);
            return fileEntry.getUuid();
        }
        catch (PortalException portalException) {
            String message = StringBundler.concat((Object[])new Object[]{"Unable to get file entry with group ID ", groupId, ", folder ID ", folderId, ", and title ", title});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)portalException);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
            throw portalException;
        }
    }
}

