/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_3;

import com.liferay.asset.entry.rel.service.AssetEntryAssetCategoryRelLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JournalArticleTypeUpgradeProcess
extends UpgradeProcess {
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetEntryAssetCategoryRelLocalService _assetEntryAssetCategoryRelLocalService;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final AssetVocabularyLocalService _assetVocabularyLocalService;
    private final CompanyLocalService _companyLocalService;
    private final UserLocalService _userLocalService;

    public JournalArticleTypeUpgradeProcess(AssetCategoryLocalService assetCategoryLocalService, AssetEntryAssetCategoryRelLocalService assetEntryAssetCategoryRelLocalService, AssetEntryLocalService assetEntryLocalService, AssetVocabularyLocalService assetVocabularyLocalService, CompanyLocalService companyLocalService, UserLocalService userLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetEntryAssetCategoryRelLocalService = assetEntryAssetCategoryRelLocalService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._assetVocabularyLocalService = assetVocabularyLocalService;
        this._companyLocalService = companyLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateArticleType();
        this._alterTable();
    }

    private AssetCategory _addAssetCategory(long groupId, long companyId, String title, long assetVocabularyId) throws Exception {
        long userId = this._userLocalService.getDefaultUserId(companyId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this._assetCategoryLocalService.addCategory(userId, groupId, title, assetVocabularyId, serviceContext);
    }

    private AssetVocabulary _addAssetVocabulary(long groupId, long companyId, String title, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws Exception {
        long userId = this._userLocalService.getDefaultUserId(companyId);
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper();
        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{PortalUtil.getClassNameId((String)JournalArticle.class.getName())}, new long[]{-1L}, new boolean[]{false});
        assetVocabularySettingsHelper.setMultiValued(false);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this._assetVocabularyLocalService.addVocabulary(userId, groupId, title, nameMap, descriptionMap, assetVocabularySettingsHelper.toString(), serviceContext);
    }

    private void _alterTable() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.alterTableDropColumn("JournalArticle", "type_");
        }
    }

    /*
     * Exception decompiling
     */
    private Set<String> _getArticleTypes() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean _hasSelectedArticleTypes() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _updateArticles(long companyId, Map<String, Long> journalArticleTypesToAssetCategoryIds) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select JournalArticle.resourcePrimKey, ", "JournalArticle.type_ from JournalArticle left join ", "JournalArticle tempJournalArticle on ", "(JournalArticle.groupId = tempJournalArticle.groupId) ", "and (JournalArticle.articleId = ", "tempJournalArticle.articleId) and ", "(JournalArticle.version < tempJournalArticle.version) ", "where JournalArticle.companyId = ? and ", "tempJournalArticle.id_ is null"}));){
            preparedStatement.setLong(1, companyId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                    AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), resourcePrimKey);
                    if (assetEntry == null) continue;
                    String type = StringUtil.toLowerCase((String)resultSet.getString("type_"));
                    long assetCategoryId = journalArticleTypesToAssetCategoryIds.get(type);
                    this._assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel(assetEntry.getEntryId(), assetCategoryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateArticleType() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this._hasSelectedArticleTypes()) {
                return;
            }
            Set<String> types = this._getArticleTypes();
            if (types.size() <= 0) {
                return;
            }
            Locale localeThreadLocalDefaultLocale = LocaleThreadLocal.getDefaultLocale();
            try {
                this._companyLocalService.forEachCompany(company -> {
                    LocaleThreadLocal.setDefaultLocale((Locale)company.getLocale());
                    Set locales = LanguageUtil.getAvailableLocales((long)company.getGroupId());
                    Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)company.getCompanyId()));
                    Map nameMap = LocalizationUtil.getLocalizationMap((Collection)locales, (Locale)defaultLocale, (String)"type");
                    AssetVocabulary assetVocabulary = this._addAssetVocabulary(company.getGroupId(), company.getCompanyId(), "type", nameMap, new HashMap<Locale, String>());
                    HashMap<String, Long> journalArticleTypesToAssetCategoryIds = new HashMap<String, Long>();
                    for (String type : types) {
                        AssetCategory assetCategory = this._addAssetCategory(company.getGroupId(), company.getCompanyId(), type, assetVocabulary.getVocabularyId());
                        journalArticleTypesToAssetCategoryIds.put(type, assetCategory.getCategoryId());
                    }
                    this._updateArticles(company.getCompanyId(), journalArticleTypesToAssetCategoryIds);
                });
            }
            finally {
                LocaleThreadLocal.setDefaultLocale((Locale)localeThreadLocalDefaultLocale);
            }
        }
    }
}

