/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_5;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JournalUpgradeProcess
extends UpgradeProcess {
    private static final String _BASIC_WEB_CONTENT_STRUCTURE;
    private static final String _INVALID_FIELD_NAME_CHARS_REGEX = "([\\p{Punct}&&[^_]]|\\p{Space})+";
    private static final String _TYPE_ATTRIBUTE_DDM_DATE = "type=\"ddm-date\"";
    private static final Log _log;
    private static final DateFormat _dateFormat;
    private final CompanyLocalService _companyLocalService;
    private final DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    private final DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private final Map<Long, String> _defaultLanguageIds = new HashMap<Long, String>();
    private final GroupLocalService _groupLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceActions _resourceActions;
    private final ResourceLocalService _resourceLocalService;
    private final UserLocalService _userLocalService;

    public JournalUpgradeProcess(CompanyLocalService companyLocalService, DDMStorageLinkLocalService ddmStorageLinkLocalService, DDMStructureLocalService ddmStructureLocalService, DDMTemplateLinkLocalService ddmTemplateLinkLocalService, DefaultDDMStructureHelper defaultDDMStructureHelper, GroupLocalService groupLocalService, ResourceActionLocalService resourceActionLocalService, ResourceActions resourceActions, ResourceLocalService resourceLocalService, UserLocalService userLocalService) {
        this._companyLocalService = companyLocalService;
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddmTemplateLinkLocalService = ddmTemplateLinkLocalService;
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
        this._groupLocalService = groupLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceActions = resourceActions;
        this._resourceLocalService = resourceLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateJournalArticles();
        this._addDDMStorageLinks();
        this._addDDMTemplateLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _addBasicWebContentStructureAndTemplate(long companyId) throws Exception {
        this._initJournalDDMCompositeModelsResourceActions();
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        Locale oldSiteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        Locale siteDefaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
        LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        try {
            this._defaultDDMStructureHelper.addDDMStructures(defaultUserId, group.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), clazz.getClassLoader(), "com/liferay/journal/internal/upgrade/v1_0_0/dependencies/basic-web-content-structure.xml", new ServiceContext());
        }
        finally {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)oldSiteDefaultLocale);
        }
        this._addDefaultResourcePermissions(group.getGroupId());
        List<Element> structureElements = this._getDDMStructures(siteDefaultLocale);
        Element structureElement = structureElements.get(0);
        return StringUtil.toUpperCase((String)structureElement.elementText("name"));
    }

    private void _addDDMStorageLink(Map<Long, List<Long>> ddmStructureIdsMap) throws Exception {
        long journalArticleClassNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
        for (Map.Entry<Long, List<Long>> entry : ddmStructureIdsMap.entrySet()) {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._getDDMStructureId(entry.getKey(), entry.getValue()));
            DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
            this._ddmStorageLinkLocalService.addStorageLink(journalArticleClassNameId, entry.getKey().longValue(), ddmStructureVersion.getStructureVersionId(), new ServiceContext());
        }
    }

    private void _addDDMStorageLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureId, ", "JournalArticle.id_ from JournalArticle inner ", "join DDMStructure on (DDMStructure.groupId in ", "(select distinct Group_.groupId from Group_ ", "where (Group_.groupId = JournalArticle.groupId) ", "or (Group_.companyId = JournalArticle.companyId ", "and Group_.friendlyURL = ?)) and ", "DDMStructure.structureKey = ", "JournalArticle.DDMStructureKey and ", "JournalArticle.classNameId != ?)"}));){
            preparedStatement.setString(1, "/global");
            preparedStatement.setLong(2, PortalUtil.getClassNameId((String)DDMStructure.class.getName()));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                HashMap<Long, List<Long>> ddmStructureIdsMap = new HashMap<Long, List<Long>>();
                while (resultSet.next()) {
                    long structureId = resultSet.getLong("structureId");
                    long id = resultSet.getLong("id_");
                    ArrayList<Long> ddmStructureIds = (ArrayList<Long>)ddmStructureIdsMap.get(id);
                    if (ddmStructureIds == null) {
                        ddmStructureIds = new ArrayList<Long>();
                    }
                    ddmStructureIds.add(structureId);
                    ddmStructureIdsMap.put(id, ddmStructureIds);
                }
                this._addDDMStorageLink(ddmStructureIdsMap);
            }
        }
    }

    private void _addDDMTemplateLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long ddmStructureClassNameId = PortalUtil.getClassNameId((String)DDMStructure.class.getName());
            long journalArticleClassNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMTemplate.templateId, ", "JournalArticle.id_ from JournalArticle inner ", "join DDMTemplate on (DDMTemplate.groupId = ", "JournalArticle.groupId and ", "DDMTemplate.templateKey = ", "JournalArticle.DDMTemplateKey and ", "JournalArticle.classNameId != ? and ", "DDMTemplate.classNameId = ?)"}));){
                preparedStatement.setLong(1, ddmStructureClassNameId);
                preparedStatement.setLong(2, ddmStructureClassNameId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        long templateId = resultSet.getLong("templateId");
                        long id = resultSet.getLong("id_");
                        this._ddmTemplateLinkLocalService.addTemplateLink(journalArticleClassNameId, id, templateId);
                    }
                }
            }
        }
    }

    private void _addDefaultResourcePermissions(long groupId) throws Exception {
        String modelResource = this._resourceActions.getCompositeModelName(new String[]{DDMStructure.class.getName(), JournalArticle.class.getName()});
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId(JournalArticle.class), "BASIC-WEB-CONTENT");
        this._resourceLocalService.addResources(ddmStructure.getCompanyId(), 0L, 0L, modelResource, ddmStructure.getStructureId(), false, false, true);
    }

    private boolean _containsDateFieldType(String content) {
        return content.indexOf(_TYPE_ATTRIBUTE_DDM_DATE) != -1;
    }

    private String _convertStaticContentToDynamic(long groupId, String content) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        Document newDocument = SAXReaderUtil.createDocument();
        Element rootElement = document.getRootElement();
        String defaultLanguageId = this._getDefaultLanguageId(groupId);
        String availableLocales = GetterUtil.getString((String)rootElement.attributeValue("available-locales"), (String)defaultLanguageId);
        String defaultLocale = GetterUtil.getString((String)rootElement.attributeValue("default-locale"), (String)defaultLanguageId);
        Element newRootElement = SAXReaderUtil.createElement((String)"root");
        newRootElement.addAttribute("available-locales", availableLocales);
        newRootElement.addAttribute("default-locale", defaultLocale);
        newDocument.add(newRootElement);
        Element dynamicElementElement = SAXReaderUtil.createElement((String)"dynamic-element");
        dynamicElementElement.addAttribute("name", "content");
        dynamicElementElement.addAttribute("type", "text_area");
        dynamicElementElement.addAttribute("index-type", "text");
        dynamicElementElement.addAttribute("index", String.valueOf(0));
        newRootElement.add(dynamicElementElement);
        List staticContentElements = rootElement.elements("static-content");
        for (Element staticContentElement : staticContentElements) {
            String languageId = GetterUtil.getString((String)staticContentElement.attributeValue("language-id"), (String)defaultLanguageId);
            String text = staticContentElement.getText();
            Element dynamicContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            dynamicContentElement.addAttribute("language-id", languageId);
            dynamicContentElement.addCDATA(text);
            dynamicElementElement.add(dynamicContentElement);
        }
        return newDocument.formattedString("  ");
    }

    private String _fixStaticContent(long id, String content, DocumentException documentException) throws Exception {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Detected invalid content in journal article " + id));
        }
        if (!content.contains("<static-content ") && !content.contains("</static-content>")) {
            _log.error((Object)("Journal article " + id + " does not have static content"));
            throw documentException;
        }
        String message = documentException.getMessage();
        if (!message.contains("The entity \"reg\" was referenced, but not declared.")) {
            _log.error((Object)("Journal article " + id + " does not have invalid content due to LPS-23332"));
            throw documentException;
        }
        content = HtmlUtil.unescape((String)content);
        int index = content.indexOf("<static-content ");
        index = content.indexOf(">", index);
        content = content.substring(0, index + 1) + "<![CDATA[" + content.substring(index + 1);
        content = StringUtil.replace((String)content, (String)"</static-content>", (String)"]]></static-content>");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Fixed static content: " + content));
        }
        return content;
    }

    private Set<String> _getArticleDynamicElements(Element rootElement) {
        ArrayList<String> dynamicElementNames = new ArrayList<String>();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element element : dynamicElementElements) {
            dynamicElementNames.add(element.attributeValue("name"));
            dynamicElementNames.addAll(this._getArticleDynamicElements(element));
        }
        return SetUtil.fromList(dynamicElementNames);
    }

    private Set<String> _getArticleFieldNames(long articleId) throws Exception {
        Set<String> articleFieldNames = new HashSet<String>();
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String sql = "select JournalArticle.content from JournalArticle where JournalArticle.id_ = ?";
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
                preparedStatement.setLong(1, articleId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        String content = resultSet.getString("content");
                        Document document = SAXReaderUtil.read((String)content);
                        articleFieldNames = this._getArticleDynamicElements(document.getRootElement());
                    }
                }
            }
        }
        return articleFieldNames;
    }

    private long _getBestDDMStructureIdMatch(long id, long ddmStructureId1, long ddmStructureId2) throws Exception {
        DDMStructure ddmStructure1 = this._ddmStructureLocalService.getStructure(ddmStructureId1);
        Set fieldNames1 = ddmStructure1.getFieldNames();
        Set<String> articleFieldNames = this._getArticleFieldNames(id);
        fieldNames1.removeAll(articleFieldNames);
        DDMStructure ddmStructure2 = this._ddmStructureLocalService.getStructure(ddmStructureId2);
        Set fieldNames2 = ddmStructure2.getFieldNames();
        fieldNames2.removeAll(articleFieldNames);
        if (fieldNames1.size() <= fieldNames2.size()) {
            return ddmStructure1.getStructureId();
        }
        return ddmStructure2.getStructureId();
    }

    private long _getDDMStructureId(long id, List<Long> ddmStructureIds) throws Exception {
        if (ddmStructureIds.size() == 1) {
            return ddmStructureIds.get(0);
        }
        return this._getBestDDMStructureIdMatch(id, ddmStructureIds.get(0), ddmStructureIds.get(1));
    }

    private List<Element> _getDDMStructures(Locale locale) throws Exception {
        String xml = StringUtil.replace((String)_BASIC_WEB_CONTENT_STRUCTURE, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    private String _getDefaultLanguageId(long groupId) throws Exception {
        String defaultLanguageId = this._defaultLanguageIds.get(groupId);
        if (defaultLanguageId == null) {
            Locale defaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
            defaultLanguageId = LanguageUtil.getLanguageId((Locale)defaultLocale);
            this._defaultLanguageIds.put(groupId, defaultLanguageId);
        }
        return defaultLanguageId;
    }

    private Map<String, String> _getInvalidDDMFormFieldNamesMap(String content) throws Exception {
        HashMap<String, String> invalidDDMFormFieldNamesMap = new HashMap<String, String>();
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String newFieldName;
            String oldFieldName = GetterUtil.getString((String)dynamicElementElement.attributeValue("name"));
            if (oldFieldName.equals(newFieldName = oldFieldName.replaceAll(_INVALID_FIELD_NAME_CHARS_REGEX, ""))) continue;
            invalidDDMFormFieldNamesMap.put(oldFieldName, newFieldName);
        }
        return invalidDDMFormFieldNamesMap;
    }

    private void _initJournalDDMCompositeModelsResourceActions() throws Exception {
        this._resourceActions.populateModelResources(JournalUpgradeProcess.class.getClassLoader(), new String[]{"/resource-actions/journal_ddm_composite_models.xml"});
    }

    private void _transformDateFieldValue(Element dynamicContentElement) {
        String value = dynamicContentElement.getText();
        if (!Validator.isNumber((String)value)) {
            return;
        }
        Date date = new Date(GetterUtil.getLong((String)value));
        dynamicContentElement.clearContent();
        dynamicContentElement.addCDATA(_dateFormat.format(date));
    }

    private void _transformDateFieldValues(List<Element> dynamicElementElements) {
        if (ListUtil.isEmpty(dynamicElementElements)) {
            return;
        }
        for (Element dynamicElementElement : dynamicElementElements) {
            String type = GetterUtil.getString((String)dynamicElementElement.attributeValue("type"));
            if (type.equals("ddm-date")) {
                List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    this._transformDateFieldValue(dynamicContentElement);
                }
            }
            List childDynamicElementElements = dynamicElementElement.elements("dynamic-element");
            this._transformDateFieldValues(childDynamicElementElements);
        }
    }

    private String _transformDateFieldValues(String content) throws Exception {
        if (!this._containsDateFieldType(content)) {
            return content;
        }
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        this._transformDateFieldValues(dynamicElementElements);
        return document.formattedString("  ");
    }

    private String _transformFieldNames(String content) throws Exception {
        Map<String, String> invalidDDMFormFieldNamesMap = this._getInvalidDDMFormFieldNamesMap(content);
        for (Map.Entry<String, String> entry : invalidDDMFormFieldNamesMap.entrySet()) {
            content = StringUtil.replace((String)content, (String)("name=\"" + entry.getKey() + "\""), (String)("name=\"" + entry.getValue() + "\""));
        }
        return content;
    }

    private void _updateJournalArticle(long id, String ddmStructureKey, String ddmTemplateKey, String content) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update JournalArticle set DDMStructureKey = ?, DDMTemplateKey = ?, content = ? where id_ = ?");){
            preparedStatement.setString(1, ddmStructureKey);
            preparedStatement.setString(2, ddmTemplateKey);
            preparedStatement.setString(3, content);
            preparedStatement.setLong(4, id);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateJournalArticleContent(long id, String content) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update JournalArticle set content = ? where id_ = ?");){
            preparedStatement.setString(1, content);
            preparedStatement.setLong(2, id);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateJournalArticles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> this._updateJournalArticles((long)companyId));
        }
    }

    private void _updateJournalArticles(long companyId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select id_, groupId, content, DDMStructureKey from JournalArticle where companyId = " + companyId);
             ResultSet resultSet = preparedStatement.executeQuery();){
            String name = this._addBasicWebContentStructureAndTemplate(companyId);
            while (resultSet.next()) {
                long id = resultSet.getLong("id_");
                String content = resultSet.getString("content");
                String ddmStructureKey = resultSet.getString("DDMStructureKey");
                if (Validator.isNull((String)ddmStructureKey)) {
                    long groupId = resultSet.getLong("groupId");
                    try {
                        content = this._convertStaticContentToDynamic(groupId, content);
                    }
                    catch (DocumentException documentException) {
                        content = this._fixStaticContent(id, content, documentException);
                        content = this._convertStaticContentToDynamic(groupId, content);
                    }
                    catch (Exception exception) {
                        _log.error((Object)StringBundler.concat((Object[])new Object[]{"ID: ", id, "\nGroup ID: ", groupId, "\nContent: ", content}));
                        throw exception;
                    }
                    this._updateJournalArticle(id, name, name, content);
                    continue;
                }
                String updatedContent = this._transformDateFieldValues(content);
                if (content.equals(updatedContent = this._transformFieldNames(updatedContent))) continue;
                this._updateJournalArticleContent(id, updatedContent);
            }
        }
    }

    static {
        _log = LogFactoryUtil.getLog(JournalUpgradeProcess.class);
        _dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
        try {
            _BASIC_WEB_CONTENT_STRUCTURE = StringUtil.read((ClassLoader)JournalUpgradeProcess.class.getClassLoader(), (String)"com/liferay/journal/internal/upgrade/v1_0_0/dependencies/basic-web-content-structure.xml");
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }
}

