/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_6;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class ImageTypeContentAttributesUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ImageTypeContentAttributesUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._updateContentImages();
    }

    private String _addImageContentAttributes(long id, String content) throws Exception {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"ID: ", id, "\nContent: ", content}));
            throw exception;
        }
        document = document.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPath.selectNodes((Object)document);
        for (Node imageNode : imageNodes) {
            Element imageElement = (Element)imageNode;
            List dynamicContentElements = imageElement.elements("dynamic-content");
            String articleImageId = null;
            for (Element dynamicContentElement : dynamicContentElements) {
                articleImageId = dynamicContentElement.attributeValue("id");
                dynamicContentElement.addAttribute("alt", "");
                dynamicContentElement.addAttribute("name", articleImageId);
                dynamicContentElement.addAttribute("title", articleImageId);
                dynamicContentElement.addAttribute("type", "journal");
            }
            if (!Validator.isNotNull(articleImageId)) continue;
            imageElement.addAttribute("instance-id", this._getImageInstanceId(articleImageId));
        }
        return document.formattedString();
    }

    private String _getImageInstanceId(String articleImageId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select elInstanceId from JournalArticleImage where articleImageId = ?");){
            preparedStatement.setLong(1, Long.valueOf(articleImageId));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
            String string = "";
            return string;
        }
    }

    private void _updateContentImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select id_, content from JournalArticle where content like '%type=\"image\"%'");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");){
            while (resultSet.next()) {
                long id = resultSet.getLong(1);
                preparedStatement2.setString(1, this._addImageContentAttributes(id, resultSet.getString(2)));
                preparedStatement2.setLong(2, id);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

