/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_8;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ArticleAssetsUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ArticleAssetsUpgradeProcess.class);
    private final AssetEntryLocalService _assetEntryLocalService;
    private final CompanyLocalService _companyLocalService;

    public ArticleAssetsUpgradeProcess(AssetEntryLocalService assetEntryLocalService, CompanyLocalService companyLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateDefaultDraftArticleAssets();
    }

    private void _updateDefaultDraftArticleAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> this._updateDefaultDraftArticleAssets((long)companyId));
        }
    }

    private void _updateDefaultDraftArticleAssets(long companyId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select resourcePrimKey, indexable from JournalArticle ", "where companyId = ", companyId, " and version = ", 1.0, " and status = ", 2}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), resourcePrimKey);
                if (assetEntry == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Journal article with resource primary key ", resourcePrimKey, " does not have associated ", "asset entry"}));
                    continue;
                }
                boolean indexable = resultSet.getBoolean("indexable");
                this._assetEntryLocalService.updateEntry(assetEntry.getClassName(), assetEntry.getClassPK(), null, null, indexable, assetEntry.isVisible());
            }
        }
    }
}

