/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_8;

import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class ArticleExpirationDateUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._updateArticleExpirationDate();
    }

    private void _updateArticleExpirationDate() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            if (!journalServiceConfiguration.expireAllArticleVersionsEnabled()) {
                return;
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select JournalArticle.* from JournalArticle left ", "join JournalArticle tempJournalArticle on ", "(JournalArticle.groupId = ", "tempJournalArticle.groupId) and ", "(JournalArticle.articleId = ", "tempJournalArticle.articleId) and ", "(JournalArticle.version < ", "tempJournalArticle.version) and ", "(JournalArticle.status = ", "tempJournalArticle.status) where ", "(JournalArticle.classNameId = ", 0L, ") and (tempJournalArticle.version is null) and ", "(JournalArticle.expirationDate is not null) and ", "(JournalArticle.status = ", 0, ")"}));
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    String articleId = resultSet.getString("articleId");
                    Timestamp expirationDate = resultSet.getTimestamp("expirationDate");
                    int status = resultSet.getInt("status");
                    this._updateExpirationDate(groupId, articleId, expirationDate, status);
                }
            }
        }
    }

    private void _updateExpirationDate(long groupId, String articleId, Timestamp expirationDate, int status) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update JournalArticle set expirationDate = ? where groupId = ? and articleId = ? and status = ?");){
            preparedStatement.setTimestamp(1, expirationDate);
            preparedStatement.setLong(2, groupId);
            preparedStatement.setString(3, articleId);
            preparedStatement.setInt(4, status);
            preparedStatement.executeUpdate();
        }
    }
}

