/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_8;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class ArticleSystemEventsUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.journal.model.JournalArticle";
    private static final Log _log = LogFactoryUtil.getLog(ArticleSystemEventsUpgradeProcess.class);
    private final SystemEventLocalService _systemEventLocalService;

    public ArticleSystemEventsUpgradeProcess(SystemEventLocalService systemEventLocalService) {
        this._systemEventLocalService = systemEventLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._deleteJournalArticleSystemEvents();
    }

    private void _deleteJournalArticleSystemEvents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DynamicQuery dynamicQuery = this._systemEventLocalService.dynamicQuery();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)PortalUtil.getClassNameId((String)_CLASS_NAME)));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)1));
            List systemEvents = this._systemEventLocalService.dynamicQuery(dynamicQuery);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Processing ", systemEvents.size(), " delete system events for journal articles"}));
            }
            for (SystemEvent systemEvent : systemEvents) {
                Throwable throwable;
                ResultSet resultSet;
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
                if (extraDataJSONObject.has("uuid") || !extraDataJSONObject.has("version")) continue;
                String articleId = null;
                try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select articleId from JournalArticleResource ", "where JournalArticleResource.uuid_ = ? and ", "JournalArticleResource.groupId = ?"}));){
                    preparedStatement.setString(1, systemEvent.getClassUuid());
                    preparedStatement.setLong(2, systemEvent.getGroupId());
                    resultSet = preparedStatement.executeQuery();
                    throwable = null;
                    try {
                        if (resultSet.next()) {
                            articleId = resultSet.getString(1);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resultSet != null) {
                            if (throwable != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                if (articleId == null) continue;
                preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select 1 from JournalArticle where groupId = ", "? and articleId = ? and version = ? and ", "status = ?"}));
                var12_14 = null;
                try {
                    preparedStatement.setLong(1, systemEvent.getGroupId());
                    preparedStatement.setString(2, articleId);
                    preparedStatement.setDouble(3, extraDataJSONObject.getDouble("version"));
                    preparedStatement.setInt(4, 8);
                    resultSet = preparedStatement.executeQuery();
                    throwable = null;
                    try {
                        if (!resultSet.next()) continue;
                        this._systemEventLocalService.deleteSystemEvent(systemEvent);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable6) {
                    var12_14 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (var12_14 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable7) {
                            var12_14.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete system events verified for journal articles");
            }
        }
    }
}

