/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JournalArticleImageUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._deleteOrphanJournalArticleImages();
        this._updateJournalArticleImagesInstanceId();
        this._updateJournalArticleImagesName();
    }

    private void _deleteOrphanJournalArticleImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"delete from JournalArticleImage where not exists", "(select 1 from Image where", "(JournalArticleImage.articleImageId = Image.imageId))"}));){
            preparedStatement.executeUpdate();
        }
    }

    private void _updateJournalArticleImagesInstanceId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select articleId, elName from JournalArticleImage where (elInstanceId = '' or elInstanceId is null) group by articleId, elName");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update JournalArticleImage set elInstanceId = ? where articleId = ? and elName = ?");){
            while (resultSet.next()) {
                String articleId = resultSet.getString(1);
                String elName = resultSet.getString(2);
                preparedStatement2.setString(1, StringUtil.randomString((int)4));
                preparedStatement2.setString(2, articleId);
                preparedStatement2.setString(3, elName);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _updateJournalArticleImagesName() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select articleImageId, elName from JournalArticleImage");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update JournalArticleImage set elName = ? where articleImageId = ?");){
            while (resultSet.next()) {
                String index;
                String elName = resultSet.getString(2);
                int lastIndexOf = elName.lastIndexOf("_");
                if (lastIndexOf < 1 || !Validator.isNumber((String)(index = elName.substring(lastIndexOf + 1)))) continue;
                preparedStatement2.setString(1, elName.substring(0, lastIndexOf));
                preparedStatement2.setLong(2, resultSet.getLong(1));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

