/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_0_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JournalContentSearchUpgradeProcess
extends UpgradeProcess {
    private static final String _NEW_ROOT_PORTLET_ID = "com_liferay_journal_content_web_portlet_JournalContentPortlet";
    private static final String _OLD_ROOT_PORTLET_ID = "56";

    protected void doUpgrade() throws Exception {
        this._upgradePortletId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _upgradePortletId() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from JournalContentSearch where portletId like '56%'");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select contentSearchId from JournalContentSearch where groupId = ? AND privateLayout = ? AND layoutId = ? AND portletId = ? AND articleId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalContentSearch set portletId = ? where contentSearchId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                ResultSet resultSet2;
                block60: {
                    long contentSearchId = resultSet.getLong("contentSearchId");
                    long groupId = resultSet.getLong("groupId");
                    boolean privateLayout = resultSet.getBoolean("privateLayout");
                    long layoutId = resultSet.getLong("layoutId");
                    String portletId = resultSet.getString("portletId");
                    String articleId = resultSet.getString("articleId");
                    String newPortletId = StringUtil.replaceFirst((String)portletId, (String)_OLD_ROOT_PORTLET_ID, (String)_NEW_ROOT_PORTLET_ID);
                    preparedStatement2.setLong(1, groupId);
                    preparedStatement2.setBoolean(2, privateLayout);
                    preparedStatement2.setLong(3, layoutId);
                    preparedStatement2.setString(4, newPortletId);
                    preparedStatement2.setString(5, articleId);
                    resultSet2 = preparedStatement2.executeQuery();
                    Throwable throwable = null;
                    try {
                        if (resultSet2.next()) {
                            this.runSQL("delete from JournalContentSearch where contentSearchId = " + contentSearchId);
                        } else {
                            preparedStatement3.setString(1, newPortletId);
                            preparedStatement3.setLong(2, contentSearchId);
                            preparedStatement3.addBatch();
                        }
                        if (resultSet2 == null) continue;
                        if (throwable == null) break block60;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (resultSet2 == null) throw throwable3;
                            if (throwable == null) {
                                resultSet2.close();
                                throw throwable3;
                            }
                            try {
                                resultSet2.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        resultSet2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                resultSet2.close();
            }
            preparedStatement3.executeBatch();
            return;
        }
    }
}

