/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.journal.internal.upgrade.helper.JournalArticleImageUpgradeHelper;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class DocumentLibraryTypeContentUpgradeProcess
extends UpgradeProcess {
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;

    public DocumentLibraryTypeContentUpgradeProcess(JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper) {
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
    }

    protected void doUpgrade() throws Exception {
        this._updateContent();
    }

    private String _convertContent(String content) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='document_library']");
        List imageNodes = xPath.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                String data = this._journalArticleImageUpgradeHelper.getDocumentLibraryValue(dynamicContentEl.getText());
                dynamicContentEl.clearContent();
                dynamicContentEl.addCDATA(data);
            }
        }
        return contentDocument.formattedString();
    }

    private void _updateContent() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select content, id_ from JournalArticle where content like '%type=\"document_library\"%'");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._convertContent(resultSet.getString(1)));
                preparedStatement2.setLong(2, resultSet.getLong(2));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

