/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.journal.internal.upgrade.helper.JournalArticleImageUpgradeHelper;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class ImageTypeContentUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ImageTypeContentUpgradeProcess.class);
    private final ImageLocalService _imageLocalService;
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;
    private final PortletFileRepository _portletFileRepository;

    public ImageTypeContentUpgradeProcess(ImageLocalService imageLocalService, JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper, PortletFileRepository portletFileRepository) {
        this._imageLocalService = imageLocalService;
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
        this._portletFileRepository = portletFileRepository;
    }

    protected void doUpgrade() throws Exception {
        this._copyJournalArticleImagesToJournalRepository();
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"JournalArticleImage"})};
    }

    private void _copyJournalArticleImagesToJournalRepository() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.processConcurrently(StringBundler.concat((String[])new String[]{"select JournalArticleImage.articleImageId, ", "JournalArticleImage.groupId, ", "JournalArticleImage.companyId, ", "JournalArticle.resourcePrimKey, JournalArticle.userId ", "from JournalArticleImage inner join JournalArticle on ", "(JournalArticle.groupId = JournalArticleImage.groupId ", "and JournalArticle.articleId = ", "JournalArticleImage.articleId and JournalArticle.version ", "= JournalArticleImage.version)"}), resultSet -> {
                long articleImageId = resultSet.getLong(1);
                long groupId = resultSet.getLong(2);
                long companyId = resultSet.getLong(3);
                long resourcePrimKey = resultSet.getLong(4);
                long userId = PortalUtil.getValidUserId((long)companyId, (long)resultSet.getLong(5));
                long folderId = this._journalArticleImageUpgradeHelper.getFolderId(userId, groupId, resourcePrimKey);
                return new Object[]{articleImageId, groupId, resourcePrimKey, userId, folderId};
            }, values -> {
                String fileName;
                long folderId;
                long articleImageId = (Long)values[0];
                long groupId = (Long)values[1];
                FileEntry fileEntry = this._portletFileRepository.fetchPortletFileEntry(groupId, folderId = ((Long)values[4]).longValue(), fileName = String.valueOf(articleImageId));
                if (fileEntry != null) {
                    return;
                }
                long resourcePrimKey = (Long)values[2];
                long userId = (Long)values[3];
                try {
                    Image image = this._imageLocalService.getImage(articleImageId);
                    if (image == null) {
                        return;
                    }
                    String mimeType = MimeTypesUtil.getContentType((String)(fileName + "." + image.getType()));
                    this._portletFileRepository.addPortletFileEntry(groupId, userId, JournalArticle.class.getName(), resourcePrimKey, "com.liferay.journal", folderId, image.getTextObj(), fileName, mimeType, false);
                    this._imageLocalService.deleteImage(image.getImageId());
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to add the journal article image " + fileName + " into the file repository"), (Throwable)exception);
                    throw exception;
                }
            }, "Unable to copy journal article images to the file repository");
        }
    }
}

