/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_0;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class JournalArticleLocalizedValuesUpgradeProcess
extends UpgradeProcess {
    private static final int _MAX_LENGTH_DESCRIPTION = 4000;
    private static final int _MAX_LENGTH_TITLE = 800;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleLocalizedValuesUpgradeProcess.class);
    private final CounterLocalService _counterLocalService;

    public JournalArticleLocalizedValuesUpgradeProcess(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("JournalArticle", "title") || !this.hasColumn("JournalArticle", "description")) {
            throw new IllegalStateException("JournalArticle must have title and description columns");
        }
        this._upgradeSchema();
        this._updateJournalArticleDefaultLanguageId();
        this._updateJournalArticleLocalizedFields();
        this._dropTitleColumn();
        this._dropDescriptionColumn();
    }

    private void _dropDescriptionColumn() throws Exception {
        block2: {
            try {
                this.alterTableDropColumn("JournalArticle", "description");
            }
            catch (SQLException sqlException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)sqlException);
            }
        }
    }

    private void _dropTitleColumn() throws Exception {
        block2: {
            try {
                this.alterTableDropColumn("JournalArticle", "title");
            }
            catch (SQLException sqlException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)sqlException);
            }
        }
    }

    private Map<Locale, String> _getLocalizationMap(String value, String defaultLanguageId) {
        if (Validator.isXml((String)value)) {
            return LocalizationUtil.getLocalizationMap((String)value);
        }
        return HashMapBuilder.put((Object)LocaleUtil.fromLanguageId((String)defaultLanguageId), (Object)value).build();
    }

    private void _log(long articleId, String columnName) {
        if (!_log.isWarnEnabled()) {
            return;
        }
        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Truncated the ", columnName, " value for article ", articleId, " because it is too long"}));
    }

    private String _truncate(String text, int maxBytes) throws Exception {
        byte[] valueBytes = text.getBytes("UTF-8");
        if (valueBytes.length <= maxBytes) {
            return text;
        }
        byte[] convertedValue = new byte[maxBytes];
        System.arraycopy(valueBytes, 0, convertedValue, 0, maxBytes);
        String returnValue = new String(convertedValue, "UTF-8");
        return StringUtil.shorten((String)returnValue, (int)(returnValue.length() - 1));
    }

    /*
     * Exception decompiling
     */
    private void _updateDefaultLanguage(String columnName, boolean strictUpdate) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _updateJournalArticleDefaultLanguageId() throws Exception {
        this.alterTableAddColumn("JournalArticle", "defaultLanguageId", "VARCHAR(75) null");
        this._updateDefaultLanguage("title", false);
        this._updateDefaultLanguage("content", true);
    }

    /*
     * Exception decompiling
     */
    private void _updateJournalArticleLocalizedFields() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _upgradeSchema() throws Exception {
        this.dropTable("JournalArticleLocalization");
        String template = StringUtil.read((InputStream)JournalArticleLocalizedValuesUpgradeProcess.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }

    private /* synthetic */ void lambda$_updateJournalArticleLocalizedFields$3(Object[] values, PreparedStatement preparedStatement) throws Exception {
        long id = (Long)values[0];
        long companyId = (Long)values[1];
        String title = (String)values[2];
        String description = (String)values[3];
        String defaultLanguageId = (String)values[4];
        Map<Locale, String> titleMap = this._getLocalizationMap(title, defaultLanguageId);
        Map<Locale, String> descriptionMap = this._getLocalizationMap(description, defaultLanguageId);
        HashSet<Locale> locales = new HashSet<Locale>();
        locales.addAll(titleMap.keySet());
        locales.addAll(descriptionMap.keySet());
        for (Locale locale : locales) {
            String localizedTitle = titleMap.get(locale);
            String localizedDescription = descriptionMap.get(locale);
            if (localizedTitle != null && localizedTitle.length() > 800) {
                localizedTitle = StringUtil.shorten((String)localizedTitle, (int)800);
                this._log(id, "title");
            }
            if (localizedDescription != null) {
                String safeLocalizedDescription = this._truncate(localizedDescription, 4000);
                if (localizedDescription != safeLocalizedDescription) {
                    this._log(id, "description");
                }
                localizedDescription = safeLocalizedDescription;
            }
            preparedStatement.setLong(1, this._counterLocalService.increment());
            preparedStatement.setLong(2, companyId);
            preparedStatement.setLong(3, id);
            preparedStatement.setString(4, localizedTitle);
            preparedStatement.setString(5, localizedDescription);
            preparedStatement.setString(6, LocaleUtil.toLanguageId((Locale)locale));
            preparedStatement.addBatch();
        }
    }

    private /* synthetic */ void lambda$_updateDefaultLanguage$1(boolean strictUpdate, Map defaultSiteLocales, Object[] values) throws Exception {
        String columnValue = (String)values[2];
        if (Validator.isXml((String)columnValue) || strictUpdate) {
            long groupId = (Long)values[1];
            Locale defaultSiteLocale = (Locale)defaultSiteLocales.get(groupId);
            if (defaultSiteLocale == null) {
                defaultSiteLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
                defaultSiteLocales.put(groupId, defaultSiteLocale);
            }
            long id = (Long)values[0];
            String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)columnValue, (Locale)defaultSiteLocale);
            try {
                this.runSQL(this.connection, StringBundler.concat((Object[])new Object[]{"update JournalArticle set ", "defaultLanguageId = '", defaultLanguageId, "' where id_ = ", id}));
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to update default language ID for article " + id), (Throwable)exception);
                throw exception;
            }
        }
    }
}

