/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_2;

import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CheckIntervalConfigurationUpgradeProcess
extends UpgradeProcess {
    private final ConfigurationAdmin _configurationAdmin;

    public CheckIntervalConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeCheckIntervalConfiguration();
    }

    private void _upgradeCheckIntervalConfiguration() throws Exception {
        String filterString = StringBundler.concat((String[])new String[]{"(", "service.pid", "=", JournalServiceConfiguration.class.getName(), ")"});
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            return;
        }
        Configuration configuration = configurations[0];
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return;
        }
        long checkIntervalMilliseconds = GetterUtil.getLong(properties.get("checkInterval"));
        long checkIntervalMinutes = checkIntervalMilliseconds / 60000L;
        int checkInterval = Integer.MAX_VALUE;
        if (checkIntervalMinutes <= Integer.MAX_VALUE) {
            checkInterval = (int)checkIntervalMinutes;
        }
        properties.put("checkInterval", checkInterval);
        configuration.update(properties);
    }
}

