/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_3;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ResourcePermissionsUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ResourcePermissionsUpgradeProcess.class);
    private final ResourceActions _resourceActions;

    public ResourcePermissionsUpgradeProcess(ResourceActions resourceActions) {
        this._resourceActions = resourceActions;
    }

    protected void doUpgrade() throws Exception {
        String modelResource = this._resourceActions.getCompositeModelName(new String[]{DDMStructure.class.getName(), JournalArticle.class.getName()});
        this._updateResourcePermissions("com.liferay.journal.model.JournalStructure", modelResource);
        modelResource = this._resourceActions.getCompositeModelName(new String[]{DDMTemplate.class.getName(), JournalArticle.class.getName()});
        this._updateResourcePermissions("com.liferay.journal.model.JournalTemplate", modelResource);
    }

    private void _updateResourcePermissions(String oldClassName, String newClassName) {
        block14: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("update ResourcePermission set name = ? where name = ?");){
                preparedStatement.setString(1, newClassName);
                preparedStatement.setString(2, oldClassName);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sqlException) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Throwable)sqlException);
            }
        }
    }
}

