/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_5;

import com.liferay.journal.internal.upgrade.helper.JournalArticleImageUpgradeHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class ContentImagesUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ContentImagesUpgradeProcess.class);
    private final JournalArticleImageUpgradeHelper _journalArticleImageUpgradeHelper;

    public ContentImagesUpgradeProcess(JournalArticleImageUpgradeHelper journalArticleImageUpgradeHelper) {
        this._journalArticleImageUpgradeHelper = journalArticleImageUpgradeHelper;
    }

    protected void doUpgrade() throws Exception {
        this._updateContentImages();
    }

    private String _convertTypeImageElements(long userId, long groupId, long companyId, String content, long resourcePrimKey) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPath.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageElement = (Element)imageNode;
            List dynamicContentElements = imageElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                FileEntry fileEntry;
                boolean emptyDynamicContentElement;
                long fileEntryId;
                block12: {
                    fileEntryId = GetterUtil.getLong((String)dynamicContentElement.attributeValue("fileEntryId"));
                    String id = dynamicContentElement.attributeValue("id");
                    emptyDynamicContentElement = false;
                    fileEntry = null;
                    if (Validator.isNotNull((String)id)) {
                        fileEntry = this._getFileEntryById(userId, groupId, companyId, resourcePrimKey, id);
                    } else if (fileEntryId > 0L) {
                        fileEntry = this._getFileEntryByFileEntryId(fileEntryId);
                    } else {
                        String data = String.valueOf(dynamicContentElement.getData());
                        if (Validator.isNull((String)data)) {
                            emptyDynamicContentElement = true;
                        } else {
                            fileEntry = this._journalArticleImageUpgradeHelper.getFileEntryFromURL(data);
                            if (fileEntry == null) {
                                try {
                                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)data);
                                    fileEntryId = GetterUtil.getLong((Object)jsonObject.get("fileEntryId"));
                                    fileEntry = this._getFileEntryByFileEntryId(fileEntryId);
                                }
                                catch (Exception exception) {
                                    if (!_log.isWarnEnabled()) break block12;
                                    _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)exception);
                                }
                            }
                        }
                    }
                }
                dynamicContentElement.clearContent();
                if (fileEntry == null) {
                    if (emptyDynamicContentElement || !_log.isWarnEnabled()) continue;
                    _log.warn((Object)"Deleted dynamic content because the file entry does not exist");
                    continue;
                }
                dynamicContentElement.addCDATA(JSONUtil.put((String)"alt", (Object)GetterUtil.getString((String)dynamicContentElement.attributeValue("alt"))).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", dynamicContentElement.attributeValue("name", fileEntry.getFileName())).put("resourcePrimKey", resourcePrimKey).put("title", dynamicContentElement.attributeValue("title", fileEntry.getTitle())).put("type", "journal").put("uuid", fileEntry.getUuid()).toString());
                if (fileEntryId > 0L) continue;
                dynamicContentElement.addAttribute("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
            }
        }
        return contentDocument.formattedString();
    }

    private FileEntry _getFileEntryByFileEntryId(long fileEntryId) {
        FileEntry fileEntry;
        block3: {
            fileEntry = null;
            try {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            }
            catch (PortalException portalException) {
                String message = "Unable to get file entry " + fileEntryId;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)portalException);
                }
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)message);
            }
        }
        return fileEntry;
    }

    private FileEntry _getFileEntryById(long userId, long groupId, long companyId, long resourcePrimKey, String id) throws Exception {
        FileEntry fileEntry;
        block3: {
            userId = PortalUtil.getValidUserId((long)companyId, (long)userId);
            long folderId = this._journalArticleImageUpgradeHelper.getFolderId(userId, groupId, resourcePrimKey);
            fileEntry = null;
            try {
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)id);
            }
            catch (PortalException portalException) {
                String message = StringBundler.concat((Object[])new Object[]{"Unable to get file entry with group ID ", groupId, ", folder ID ", folderId, ", and file name ", id, " for resourcePrimKey ", resourcePrimKey});
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)portalException);
                }
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)message);
            }
        }
        return fileEntry;
    }

    private void _updateContentImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select id_, resourcePrimKey, groupId, companyId, userId, content from JournalArticle where content like '%type=\"image\"%'");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._convertTypeImageElements(resultSet.getLong(5), resultSet.getLong(3), resultSet.getLong(4), resultSet.getString(6), resultSet.getLong(2)));
                preparedStatement2.setLong(2, resultSet.getLong(1));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

