/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_1_6;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AssetDisplayPageEntryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayPageEntryUpgradeProcess.class);
    private final AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    private final CompanyLocalService _companyLocalService;
    private final Map<Long, Long> _liveGroupIdsMap = new HashMap<Long, Long>();
    private final Set<Long> _stagedGroupIds = new HashSet<Long>();
    private final Map<Long, Map<String, String>> _uuidsMaps = new HashMap<Long, Map<String, String>>();

    public AssetDisplayPageEntryUpgradeProcess(AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService, CompanyLocalService companyLocalService) {
        this._assetDisplayPageEntryLocalService = assetDisplayPageEntryLocalService;
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            this._init(company.getCompanyId());
            this._updateAssetDisplayPageEntry((Company)company, true);
            this._updateAssetDisplayPageEntry((Company)company, false);
        });
    }

    private String _generateLocalStagingAwareUUID(long groupId, String journalArticleUuid) {
        Map<String, String> uuids;
        if (!this._stagedGroupIds.contains(groupId)) {
            return PortalUUIDUtil.generate();
        }
        long liveGroupId = groupId;
        if (this._liveGroupIdsMap.containsKey(groupId)) {
            liveGroupId = this._liveGroupIdsMap.get(groupId);
        }
        if (!this._uuidsMaps.containsKey(liveGroupId)) {
            this._uuidsMaps.put(liveGroupId, new HashMap());
        }
        if ((uuids = this._uuidsMaps.get(liveGroupId)).containsKey(journalArticleUuid)) {
            return uuids.get(journalArticleUuid);
        }
        String newUuid = PortalUUIDUtil.generate();
        uuids.put(journalArticleUuid, newUuid);
        return newUuid;
    }

    private void _init(long companyId) throws Exception {
        this._liveGroupIdsMap.clear();
        this._stagedGroupIds.clear();
        this._uuidsMaps.clear();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select groupId, liveGroupId from Group_ where ", "companyId = ? and liveGroupId is not null and ", "liveGroupId != 0 and remoteStagingGroupCount = 0"})));){
            preparedStatement.setLong(1, companyId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long liveGroupId = resultSet.getLong("liveGroupId");
                    this._liveGroupIdsMap.put(groupId, liveGroupId);
                    this._stagedGroupIds.add(groupId);
                    this._stagedGroupIds.add(liveGroupId);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void _updateAssetDisplayPageEntry(Company company, boolean stagingGroups) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ void lambda$_updateAssetDisplayPageEntry$2(User user, long journalArticleClassNameId, Object[] values) throws Exception {
        long groupId = (Long)values[0];
        long resourcePrimKey = (Long)values[1];
        String journalArticleUuid = (String)values[2];
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setUuid(this._generateLocalStagingAwareUUID(groupId, journalArticleUuid));
            this._assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(user.getUserId(), groupId, journalArticleClassNameId, resourcePrimKey, 0L, 2, serviceContext);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to add asset display page entry for article " + resourcePrimKey), (Throwable)exception);
            throw exception;
        }
    }
}

